<?php
require_once '../BACK/controlador_usuario.php';
$controlador = new ControladorUsuario();

if (isset($_GET['eliminar'])) {
    $controlador->eliminarUsuario($_GET['eliminar']);
    header("Location: listar_usuario.php");
    exit();
}

$usuarios = $controlador->obtenerUsuarios();
?>
<!DOCTYPE html>
<html lang = 'es'>

<head>
<meta charset = 'UTF-8' />
<meta name = 'viewport' content = 'width=device-width, initial-scale=1.0' />
<title>Encabezado y Barra Lateral Fijos</title>
<link rel = 'stylesheet' href = '../CSS/barr_enc.css'>
<link rel = 'stylesheet' href = '../CSS/listar_pedido.css'>
</head>

<body>

<header>
<div class = 'empresa'>
<img src = '../IMG/logo_actual.png' alt = 'Logo' class = 'logo'>
<span>TRANSOLAM</span>
</div>

</header>

<div class = 'contenedor'>
<aside class="sidebar">
  <nav>
    <ul>
      <li><a href="index.php">🏠 Inicio</a></li>

      <li><strong>📦 Productos</strong></li>
      <li><a href="form_guardar_producto.php">➕ Agregar Producto</a></li>
      <li><a href="listar_producto.php">📋 Listar Productos</a></li>

      <li><strong>👥 Clientes</strong></li>
      <li><a href="form_guardar_cliente.php">➕ Agregar Cliente</a></li>
      <li><a href="listar_cliente.php">📋 Listar Clientes</a></li>

      <li><strong>🧑‍💼 Conductores</strong></li>
      <li><a href="form_guardar_conductor.php">➕ Agregar Conductor</a></li>
      <li><a href="listar_conductor.php">📋 Listar Conductores</a></li>

      <li><strong>🚚 Vehículos</strong></li>
      <li><a href="form_guardar_vehiculo.php">➕ Agregar Vehículo</a></li>
      <li><a href="listar_vehiculo.php">📋 Listar Vehículos</a></li>

      <li><strong>📦 Pedidos</strong></li>
      <li><a href="form_guardar_pedido.php">➕ Agregar Pedido</a></li>
      <li><a href="listar_pedido.php">📋 Listar Pedidos</a></li>

      <li><strong>🗺️ Rutas</strong></li>
      <li><a href="form_guardar_ruta.php">➕ Agregar Ruta</a></li>
      <li><a href="listar_ruta.php">📋 Listar Rutas</a></li>

      <li><strong>👤 Usuarios</strong></li>
      <li><a href="form_guardar_usuario.php">➕ Agregar Usuario</a></li>
      <li><a href="listar_usuario.php">📋 Listar Usuarios</a></li>

      <li><strong>📑 Personas</strong></li>
      <li><a href="form_guardar_persona.php">➕ Agregar Persona</a></li>
      <li><a href="listar_persona.php">📋 Listar Personas</a></li>

      <li><strong>📊 Reportes</strong></li>
      <li><a href="reporte_ventas.php">🧾 Reporte de Ventas</a></li>
      <li><a href="reporte_clientes.php">📈 Reporte de Clientes</a></li>
      <li><a href="reporte_productos.php">📦 Reporte de Productos</a></li>

      <li><a href="listar_sesion.php">🕒 Sesiones</a></li>
      <li><a href="../BACK/cerrar_sesion.php">🚪 Salir</a></li>
    </ul>
  </nav>
</aside>

<main class = 'contenido'>
<div class="listar">
<h2>👥 Listado de Usuarios</h2>
<a href="form_guardar_usuario.php">➕ Nuevo Usuario</a>
<table>
    <tr>
        <th>ID</th>
        <th>Persona</th>
        <th>Correo</th>
        <th>Tipo</th>
        <th>Estado</th>
        <th>Acciones</th>
    </tr>
    <?php foreach ($usuarios as $u): ?>
    <tr>
        <td><?= $u['i_usu_id'] ?></td>
        <td><?= $u['v_per_nombres'] . ' ' . $u['v_per_apellido_p'] . ' ' . $u['v_per_apellido_m'] ?></td>
        <td><?= $u['v_usu_correo'] ?></td>
        <td><?= ($u['i_usu_tipo'] == 1) ? 'Admin' : 'Usuario' ?></td>
        <td><?= ($u['i_usu_estado'] == 1) ? 'Activo' : 'Inactivo' ?></td>
        <td>
            <a href="form_editar_usuario.php?editar=<?= $u['i_usu_id'] ?>">✏️ Editar</a>
            <a href="?eliminar=<?= $u['i_usu_id'] ?>" onclick="return confirm('¿Eliminar usuario?')">🗑️ Eliminar</a>
        </td>
    </tr>
    <?php endforeach; ?>
</table>
</div>


</main>
</div>

</body>

</html>