<?php
require_once '../BACK/controlador_cliente.php';
$controlador = new ControladorCliente();

if (isset($_GET['eliminar'])) {
    $controlador->eliminarCliente($_GET['eliminar']);
    header("Location: listar_cliente.php");
    exit();
}

$clientes = $controlador->obtenerClientes();
?>

<!DOCTYPE html>
<html lang = 'es'>

<head>
<meta charset = 'UTF-8' />
<meta name = 'viewport' content = 'width=device-width, initial-scale=1.0' />
<title>Encabezado y Barra Lateral Fijos</title>
<link rel = 'stylesheet' href = '../CSS/barr_enc.css'>
<link rel = 'stylesheet' href = '../CSS/listar_cliente.css'>
</head>

<body>

<header>
<div class = 'empresa'>
<img src = '../IMG/logo_actual.png' alt = 'Logo' class = 'logo'>
<span>TRANSOLAM</span>
</div>

</header>

<div class = 'contenedor'>
<aside class="sidebar">
  <nav>
    <ul>
      <li><a href="index.php">🏠 Inicio</a></li>

      <li><strong>📦 Productos</strong></li>
      <li><a href="form_guardar_producto.php">➕ Agregar Producto</a></li>
      <li><a href="listar_producto.php">📋 Listar Productos</a></li>

      <li><strong>👥 Clientes</strong></li>
      <li><a href="form_guardar_cliente.php">➕ Agregar Cliente</a></li>
      <li><a href="listar_cliente.php">📋 Listar Clientes</a></li>

      <li><strong>🧑‍💼 Conductores</strong></li>
      <li><a href="form_guardar_conductor.php">➕ Agregar Conductor</a></li>
      <li><a href="listar_conductor.php">📋 Listar Conductores</a></li>

      <li><strong>🚚 Vehículos</strong></li>
      <li><a href="form_guardar_vehiculo.php">➕ Agregar Vehículo</a></li>
      <li><a href="listar_vehiculo.php">📋 Listar Vehículos</a></li>

      <li><strong>📦 Pedidos</strong></li>
      <li><a href="form_guardar_pedido.php">➕ Agregar Pedido</a></li>
      <li><a href="listar_pedido.php">📋 Listar Pedidos</a></li>

      <li><strong>🗺️ Rutas</strong></li>
      <li><a href="form_guardar_ruta.php">➕ Agregar Ruta</a></li>
      <li><a href="listar_ruta.php">📋 Listar Rutas</a></li>

      <li><strong>👤 Usuarios</strong></li>
      <li><a href="form_guardar_usuario.php">➕ Agregar Usuario</a></li>
      <li><a href="listar_usuario.php">📋 Listar Usuarios</a></li>

      <li><strong>📑 Personas</strong></li>
      <li><a href="form_guardar_persona.php">➕ Agregar Persona</a></li>
      <li><a href="listar_persona.php">📋 Listar Personas</a></li>

      <li><strong>📊 Reportes</strong></li>
      <li><a href="reporte_ventas.php">🧾 Reporte de Ventas</a></li>
      <li><a href="reporte_clientes.php">📈 Reporte de Clientes</a></li>
      <li><a href="reporte_productos.php">📦 Reporte de Productos</a></li>

      <li><a href="listar_sesion.php">🕒 Sesiones</a></li>
      <li><a href="../BACK/cerrar_sesion.php">🚪 Salir</a></li>
    </ul>
  </nav>
</aside>

<main class = 'contenido'>
<div class="listar">
    <h2>📋 Listado de Clientes</h2>
<a href="form_guardar_cliente.php">➕ Nuevo Cliente</a>
<table>
    <tr>
        <th>ID</th>
        <th>Persona</th>
        <th>Dirección</th>
        <th>Latitud</th>
        <th>Longitud</th>
        <th>Acciones</th>
    </tr>
    <?php foreach ($clientes as $cli): ?>
    <tr>
        <td><?= $cli['i_cli_id'] ?></td>
        <td><?= $cli['v_per_nombres'] . ' ' . $cli['v_per_apellido_p'] . ' ' . $cli['v_per_apellido_m'] ?></td>
        <td><?= $cli['v_cli_direccion'] ?></td>
        <td><?= $cli['i_cli_latitud'] ?></td>
        <td><?= $cli['i_cli_longitud'] ?></td>
        <td>
            <a href="form_editar_cliente.php?editar=<?= $cli['i_cli_id'] ?>">✏️ Editar</a>
            <a href="?eliminar=<?= $cli['i_cli_id'] ?>" onclick="return confirm('¿Eliminar cliente?')">🗑️ Eliminar</a>
        </td>
    </tr>
    <?php endforeach; ?>
</table>
</div>


</main>
</div>

</body>

</html>