<?php
require_once '../BACK/controlador_pedido.php';
$controlador = new ControladorPedido();

if (isset($_POST['guardar'])) {
    $productos = [];
    foreach ($_POST['productos'] as $i => $id_pro) {
        $productos[] = [
            'id_pro' => intval($id_pro),
            'cantidad' => intval($_POST['cantidades'][$i])
        ];
    }

    $controlador->crearPedido($_POST['i_ped_id_cli'], $productos);
    header("Location: listar_pedido.php");
    exit();
}

$clientes = $controlador->obtenerClientes();
$productos = $controlador->obtenerProductos();
?>

<!DOCTYPE html>
<html lang = 'es'>

<head>
<meta charset = 'UTF-8' />
<meta name = 'viewport' content = 'width=device-width, initial-scale=1.0' />
<title>Encabezado y Barra Lateral Fijos</title>
<link rel = 'stylesheet' href = '../CSS/barr_enc.css'>
<link rel = 'stylesheet' href = '../CSS/guardar_pedido.css'>
</head>

<body>

<header>
<div class = 'empresa'>
<img src = '../IMG/logo_actual.png' alt = 'Logo' class = 'logo'>
<span>TRANSOLAM</span>
</div>

</header>

<div class = 'contenedor'>
<aside class="sidebar">
  <nav>
    <ul>
      <li><a href="index.php">🏠 Inicio</a></li>

      <li><strong>📦 Productos</strong></li>
      <li><a href="form_guardar_producto.php">➕ Agregar Producto</a></li>
      <li><a href="listar_producto.php">📋 Listar Productos</a></li>

      <li><strong>👥 Clientes</strong></li>
      <li><a href="form_guardar_cliente.php">➕ Agregar Cliente</a></li>
      <li><a href="listar_cliente.php">📋 Listar Clientes</a></li>

      <li><strong>🧑‍💼 Conductores</strong></li>
      <li><a href="form_guardar_conductor.php">➕ Agregar Conductor</a></li>
      <li><a href="listar_conductor.php">📋 Listar Conductores</a></li>

      <li><strong>🚚 Vehículos</strong></li>
      <li><a href="form_guardar_vehiculo.php">➕ Agregar Vehículo</a></li>
      <li><a href="listar_vehiculo.php">📋 Listar Vehículos</a></li>

      <li><strong>📦 Pedidos</strong></li>
      <li><a href="form_guardar_pedido.php">➕ Agregar Pedido</a></li>
      <li><a href="listar_pedido.php">📋 Listar Pedidos</a></li>

      <li><strong>🗺️ Rutas</strong></li>
      <li><a href="form_guardar_ruta.php">➕ Agregar Ruta</a></li>
      <li><a href="listar_ruta.php">📋 Listar Rutas</a></li>

      <li><strong>👤 Usuarios</strong></li>
      <li><a href="form_guardar_usuario.php">➕ Agregar Usuario</a></li>
      <li><a href="listar_usuario.php">📋 Listar Usuarios</a></li>

      <li><strong>📑 Personas</strong></li>
      <li><a href="form_guardar_persona.php">➕ Agregar Persona</a></li>
      <li><a href="listar_persona.php">📋 Listar Personas</a></li>

      <li><strong>📊 Reportes</strong></li>
      <li><a href="reporte_ventas.php">🧾 Reporte de Ventas</a></li>
      <li><a href="reporte_clientes.php">📈 Reporte de Clientes</a></li>
      <li><a href="reporte_productos.php">📦 Reporte de Productos</a></li>

      <li><a href="listar_sesion.php">🕒 Sesiones</a></li>
      <li><a href="../BACK/cerrar_sesion.php">🚪 Salir</a></li>
    </ul>
  </nav>
</aside>

<main class = 'contenido'>
  <div class="formulario-box">
    <h2>➕ Nuevo Pedido</h2>
    <div class="container mt-4">
        <form method="POST" class="card p-4 shadow-sm">
            <div class="mb-3">
                <label class="form-label">Cliente:</label>
                <select name="i_ped_id_cli" class="form-select" required>
                    <?php foreach ($clientes as $cli): ?>
                        <option value="<?= $cli['i_cli_id'] ?>">
                            <?= $cli['v_per_nombres'] . ' ' . $cli['v_per_apellido_p'] ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div id="productos" class="mb-3">
                <div class="input-group mb-2">
                      <label for="v_cli_direccion">Producto:</label>
                    <select name="productos[]" class="form-select">
                        <?php foreach ($productos as $pro): ?>
                            <option value="<?= $pro['i_pro_id'] ?>"><?= $pro['v_pro_nombre'] ?></option>
                        <?php endforeach; ?>
                    </select>
                      <label for="v_cli_direccion">Cantidad:</label>
                    <input type="number" name="cantidades[]" class="form-control" placeholder="Cantidad" required>
                </div>
            </div>
            <button type="button" class="btn btn-outline-primary mb-3" onclick="agregarProducto()">➕ Agregar Producto</button>
            <br>
            <button type="submit" name="guardar" class="btn btn-success">💾 Guardar Pedido</button>
            <a href="listar_pedido.php" class="btn btn-secondary">← Volver</a>
        </form>
    </div>
</div>
</main>
</div>
<script>
function agregarProducto() {
    const div = document.createElement('div');
    div.className = "input-group mb-2";
    div.innerHTML = `<?= "<select name='productos[]' class='form-select'>" .
        implode('', array_map(fn($p) => "<option value='{$p['i_pro_id']}'>{$p['v_pro_nombre']}</option>", $productos)) .
        "</select>" ?> <input type='number' name='cantidades[]' class='form-control' placeholder='Cantidad' required>`;
    document.getElementById('productos').appendChild(div);
}
</script>
</body>

</html>