<?php
require_once '../BACK/controlador_cliente.php';
$controlador = new ControladorCliente();

// Handle form submission
if ( $_SERVER[ 'REQUEST_METHOD' ] === 'POST' && isset( $_POST[ 'guardar' ] ) ) {
    // Validate inputs before processing
    $errors = [];

    // Validate required fields
    $requiredFields = [
        'i_cli_id_per' => 'Persona',
        'v_cli_direccion' => 'Dirección',
        'i_cli_latitud' => 'Latitud',
        'i_cli_longitud' => 'Longitud'
    ];

    foreach ( $requiredFields as $field => $label ) {
        if ( empty( $_POST[ $field ] ) ) {
            $errors[] = "El campo $label es obligatorio.";
        }
    }

    // Validate latitude and longitude
    if ( !is_numeric( $_POST[ 'i_cli_latitud' ] ) || !is_numeric( $_POST[ 'i_cli_longitud' ] ) ) {
        $errors[] = 'Latitud y Longitud deben ser valores numéricos.';
    }

    // If no errors, proceed with client creation
    if ( empty( $errors ) ) {
        try {
            $controlador->crearCliente(
                $_POST[ 'i_cli_id_per' ],
                $_POST[ 'v_cli_direccion' ],
                $_POST[ 'i_cli_latitud' ],
                $_POST[ 'i_cli_longitud' ]
            );
            // Redirect with success message
            header( 'Location: listar_cliente.php?success=1' );
            exit();
        } catch ( Exception $e ) {
            $errors[] = 'Error al crear el cliente: ' . $e->getMessage();
        }
    }
}

// Fetch personas for dropdown
try {
    $personas = $controlador->obtenerPersonas();
} catch ( Exception $e ) {
    $personas = [];
    $errors[] = 'No se pudieron cargar las personas: ' . $e->getMessage();
}
?>
<!DOCTYPE html>
<html lang = 'es'>

<head>
<meta charset = 'UTF-8' />
<meta name = 'viewport' content = 'width=device-width, initial-scale=1.0' />
<title>Encabezado y Barra Lateral Fijos</title>
<link rel = 'stylesheet' href = '../CSS/barr_enc.css'>
<link rel='stylesheet' href="../CSS/guardar_cliente.css">
</head>

<body>

<header>
<div class = 'empresa'>
<img src = '../IMG/logo_actual.png' alt = 'Logo' class = 'logo'>
<span>TRANSOLAM</span>
</div>

</header>

<div class = 'contenedor'>
<aside class="sidebar">
  <nav>
    <ul>
      <li><a href="index.php">🏠 Inicio</a></li>

      <li><strong>📦 Productos</strong></li>
      <li><a href="form_guardar_producto.php">➕ Agregar Producto</a></li>
      <li><a href="listar_producto.php">📋 Listar Productos</a></li>

      <li><strong>👥 Clientes</strong></li>
      <li><a href="form_guardar_cliente.php">➕ Agregar Cliente</a></li>
      <li><a href="listar_cliente.php">📋 Listar Clientes</a></li>

      <li><strong>🧑‍💼 Conductores</strong></li>
      <li><a href="form_guardar_conductor.php">➕ Agregar Conductor</a></li>
      <li><a href="listar_conductor.php">📋 Listar Conductores</a></li>

      <li><strong>🚚 Vehículos</strong></li>
      <li><a href="form_guardar_vehiculo.php">➕ Agregar Vehículo</a></li>
      <li><a href="listar_vehiculo.php">📋 Listar Vehículos</a></li>

      <li><strong>📦 Pedidos</strong></li>
      <li><a href="form_guardar_pedido.php">➕ Agregar Pedido</a></li>
      <li><a href="listar_pedido.php">📋 Listar Pedidos</a></li>

      <li><strong>🗺️ Rutas</strong></li>
      <li><a href="form_guardar_ruta.php">➕ Agregar Ruta</a></li>
      <li><a href="listar_ruta.php">📋 Listar Rutas</a></li>

      <li><strong>👤 Usuarios</strong></li>
      <li><a href="form_guardar_usuario.php">➕ Agregar Usuario</a></li>
      <li><a href="listar_usuario.php">📋 Listar Usuarios</a></li>

      <li><strong>📑 Personas</strong></li>
      <li><a href="form_guardar_persona.php">➕ Agregar Persona</a></li>
      <li><a href="listar_persona.php">📋 Listar Personas</a></li>

      <li><strong>📊 Reportes</strong></li>
      <li><a href="reporte_ventas.php">🧾 Reporte de Ventas</a></li>
      <li><a href="reporte_clientes.php">📈 Reporte de Clientes</a></li>
      <li><a href="reporte_productos.php">📦 Reporte de Productos</a></li>

      <li><a href="listar_sesion.php">🕒 Sesiones</a></li>
      <li><a href="../BACK/cerrar_sesion.php">🚪 Salir</a></li>
    </ul>
  </nav>
</aside>

<main class = 'contenido'>
<h2>➕ Agregar Cliente</h2>

  <?php if (!empty($errors)): ?>
      <div class="error">
          <?php foreach ($errors as $error): ?>
              <p><?= htmlspecialchars($error) ?></p>
          <?php endforeach; ?>
      </div>
  <?php endif; ?>

  <form method="POST" action="">
      <div class="form-group">
          <label for="i_cli_id_per">Persona:</label>
          <select id="i_cli_id_per" name="i_cli_id_per" required>
              <option value="">Seleccione una persona</option>
              <?php foreach ($personas as $p): ?>
                  <option value="<?= htmlspecialchars($p['i_per_id']) ?>" 
                      <?= isset($_POST['i_cli_id_per']) && $_POST['i_cli_id_per'] == $p['i_per_id'] ? 'selected' : '' ?>>
                      <?= htmlspecialchars($p['v_per_nombres'] . ' ' . $p['v_per_apellido_p'] . ' ' . $p['v_per_apellido_m']) ?>
                  </option>
              <?php endforeach; ?>
          </select>
      </div>

      <div class="form-group">
          <label for="v_cli_direccion">Dirección:</label>
          <input type="text" id="v_cli_direccion" name="v_cli_direccion" 
                 value="<?= htmlspecialchars($_POST['v_cli_direccion'] ?? '') ?>" required>
      </div>

      <div class="form-group">
          <label for="i_cli_latitud">Latitud:</label>
          <input type="number" id="i_cli_latitud" name="i_cli_latitud" step="any"
                 value="<?= htmlspecialchars($_POST['i_cli_latitud'] ?? '') ?>" required>
      </div>

      <div class="form-group">
          <label for="i_cli_longitud">Longitud:</label>
          <input type="number" id="i_cli_longitud" name="i_cli_longitud" step="any"
                 value="<?= htmlspecialchars($_POST['i_cli_longitud'] ?? '') ?>" required>
      </div>

      <div class="form-group">
          <button type="submit" name="guardar" class="btn">💾 Guardar</button>
      </div>
  </form>

  <a href="listar_cliente.php" class="volver-enlace">← Volver al listado</a>

</main>
</div>

</body>

</html>