<?php
require_once '../BACK/controlador_usuario.php';
$controlador = new ControladorUsuario();

if (!isset($_GET['editar'])) {
    header("Location: listar_usuario.php");
    exit();
}

$id = $_GET['editar'];
$usuario = $controlador->obtenerUsuarioPorId($id);
$personas = $controlador->obtenerPersonas();

if (isset($_POST['actualizar'])) {
    $controlador->actualizarUsuario(
        $id,
        $_POST['i_usu_id_per'],
        $_POST['v_usu_correo'],
        $_POST['v_usu_clave'],
        $_POST['i_usu_tipo'],
        $_POST['i_usu_estado']
    );
    header("Location: listar_usuario.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Editar Usuario</title>
</head>
<body>
<h2>✏️ Editar Usuario</h2>
<form method="POST">
    <label>Persona:
        <select name="i_usu_id_per" required>
            <?php foreach ($personas as $p): ?>
                <option value="<?= $p['i_per_id'] ?>" <?= ($usuario['i_usu_id_per'] == $p['i_per_id']) ? 'selected' : '' ?>>
                    <?= $p['v_per_nombres'] . ' ' . $p['v_per_apellido_p'] . ' ' . $p['v_per_apellido_m'] ?>
                </option>
            <?php endforeach; ?>
        </select>
    </label><br>
    <label>Correo: <input type="email" name="v_usu_correo" value="<?= $usuario['v_usu_correo'] ?>" required></label><br>
    <label>Clave (dejar vacío para no cambiarla): <input type="password" name="v_usu_clave"></label><br>
    <label>Tipo:
        <select name="i_usu_tipo">
            <option value="1" <?= $usuario['i_usu_tipo'] == 1 ? 'selected' : '' ?>>Admin</option>
            <option value="2" <?= $usuario['i_usu_tipo'] == 2 ? 'selected' : '' ?>>Usuario</option>
        </select>
    </label><br>
    <label>Estado:
        <select name="i_usu_estado">
            <option value="1" <?= $usuario['i_usu_estado'] == 1 ? 'selected' : '' ?>>Activo</option>
            <option value="0" <?= $usuario['i_usu_estado'] == 0 ? 'selected' : '' ?>>Inactivo</option>
        </select>
    </label><br>
    <button type="submit" name="actualizar">💾 Actualizar</button>
</form>
<a href="listar_usuario.php">← Volver al listado</a>
</body>
</html>
