<?php
require_once '../BACK/controlador_ruta.php';
$controlador = new ControladorRuta();

if (!isset($_GET['editar'])) {
    header("Location: listar_ruta.php");
    exit();
}

$idRuta = $_GET['editar'];
$ruta = $controlador->obtenerRutaPorId($idRuta);
$vehiculos = $controlador->obtenerVehiculos();
$detallesActuales = $controlador->obtenerDetallesRuta($idRuta);
$detallesDisponibles = $controlador->obtenerDetallesPedidoDisponibles();

if (isset($_POST['actualizar'])) {
    $controlador->actualizarRuta($idRuta, $_POST['detalles'] ?? []);
    header("Location: listar_ruta.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang = 'es'>

<head>
<meta charset = 'UTF-8' />
<meta name = 'viewport' content = 'width=device-width, initial-scale=1.0' />
<title>Encabezado y Barra Lateral Fijos</title>
<link rel = 'stylesheet' href = '../CSS/barr_enc.css'>
<link rel = 'stylesheet' href = '../CSS/editar_ruta.css'>
</head>

<body>

<header>
<div class = 'empresa'>
<img src = '../IMG/logo_actual.png' alt = 'Logo' class = 'logo'>
<span>TRANSOLAM</span>
</div>

</header>

<div class = 'contenedor'>
<aside class="sidebar">
  <nav>
    <ul>
      <li><a href="index.php">🏠 Inicio</a></li>

      <li><strong>📦 Productos</strong></li>
      <li><a href="form_guardar_producto.php">➕ Agregar Producto</a></li>
      <li><a href="listar_producto.php">📋 Listar Productos</a></li>

      <li><strong>👥 Clientes</strong></li>
      <li><a href="form_guardar_cliente.php">➕ Agregar Cliente</a></li>
      <li><a href="listar_cliente.php">📋 Listar Clientes</a></li>

      <li><strong>🧑‍💼 Conductores</strong></li>
      <li><a href="form_guardar_conductor.php">➕ Agregar Conductor</a></li>
      <li><a href="listar_conductor.php">📋 Listar Conductores</a></li>

      <li><strong>🚚 Vehículos</strong></li>
      <li><a href="form_guardar_vehiculo.php">➕ Agregar Vehículo</a></li>
      <li><a href="listar_vehiculo.php">📋 Listar Vehículos</a></li>

      <li><strong>📦 Pedidos</strong></li>
      <li><a href="form_guardar_pedido.php">➕ Agregar Pedido</a></li>
      <li><a href="listar_pedido.php">📋 Listar Pedidos</a></li>

      <li><strong>🗺️ Rutas</strong></li>
      <li><a href="form_guardar_ruta.php">➕ Agregar Ruta</a></li>
      <li><a href="listar_ruta.php">📋 Listar Rutas</a></li>

      <li><strong>👤 Usuarios</strong></li>
      <li><a href="form_guardar_usuario.php">➕ Agregar Usuario</a></li>
      <li><a href="listar_usuario.php">📋 Listar Usuarios</a></li>

      <li><strong>📑 Personas</strong></li>
      <li><a href="form_guardar_persona.php">➕ Agregar Persona</a></li>
      <li><a href="listar_persona.php">📋 Listar Personas</a></li>

      <li><strong>📊 Reportes</strong></li>
      <li><a href="reporte_ventas.php">🧾 Reporte de Ventas</a></li>
      <li><a href="reporte_clientes.php">📈 Reporte de Clientes</a></li>
      <li><a href="reporte_productos.php">📦 Reporte de Productos</a></li>

      <li><a href="listar_sesion.php">🕒 Sesiones</a></li>
      <li><a href="../BACK/cerrar_sesion.php">🚪 Salir</a></li>
    </ul>
  </nav>
</aside>

<main class = 'contenido'>
<div class="formulario-box">
  <h2>✏️ Editar Ruta</h2>
  <form method="POST" class="formulario-editar-ruta">
    <p><strong>Vehículo:</strong> (no se puede cambiar): <?= $ruta['i_rut_id_veh'] ?></p>
    <p><strong>Fecha:</strong> <?= $ruta['d_rut_fecha'] ?></p>

    <div class="seccion-pedidos">
      <label><strong>Pedidos asignados:</strong></label><br>
      <?php foreach ($detallesActuales as $d): ?>
        <label class="pedido-item">
          <input type="checkbox" name="detalles[]" value="<?= $d['i_dru_id_dpe'] ?>" checked>
          <?= $d['v_pro_nombre'] ?> - <?= $d['i_dpe_cantidad'] ?> unidades
        </label>
      <?php endforeach; ?>

      <?php foreach ($detallesDisponibles as $d): ?>
        <label class="pedido-item">
          <input type="checkbox" name="detalles[]" value="<?= $d['i_dpe_id'] ?>">
          <?= $d['v_pro_nombre'] ?> - <?= $d['i_dpe_cantidad'] ?> unidades
        </label>
      <?php endforeach; ?>
    </div>

    <div class="form-actions">
      <button type="submit" name="actualizar" class="btn-success">💾 Actualizar Ruta</button>
    </div>
  </form>
  <a href="listar_ruta.php" class="volver-enlace">← Volver</a>
</div>







</main>
</div>

</body>

</html>