<?php
require_once '../BACK/controlador_producto.php';
$controlador = new ControladorProducto();

if (!isset($_GET['editar'])) {
    header("Location: listar_producto.php");
    exit();
}

$id = $_GET['editar'];
$producto = $controlador->obtenerProductoPorId($id);

if (isset($_POST['actualizar'])) {
    $controlador->actualizarProducto(
        $id,
        $_POST['v_pro_nombre'],
        $_POST['i_pro_volumen'],
        $_POST['d_pro_precio']
    );
    header("Location: listar_producto.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang = 'es'>

<head>
<meta charset = 'UTF-8' />
<meta name = 'viewport' content = 'width=device-width, initial-scale=1.0' />
<title>Encabezado y Barra Lateral Fijos</title>
<link rel = 'stylesheet' href = '../CSS/barr_enc.css'>
<link rel = 'stylesheet' href = '../CSS/editar_producto.css'>
</head>

<body>

<header>
<div class = 'empresa'>
<img src = '../IMG/logo_actual.png' alt = 'Logo' class = 'logo'>
<span>TRANSOLAM</span>
</div>

</header>

<div class = 'contenedor'>
<aside class="sidebar">
  <nav>
    <ul>
      <li><a href="index.php">🏠 Inicio</a></li>

      <li><strong>📦 Productos</strong></li>
      <li><a href="form_guardar_producto.php">➕ Agregar Producto</a></li>
      <li><a href="listar_producto.php">📋 Listar Productos</a></li>

      <li><strong>👥 Clientes</strong></li>
      <li><a href="form_guardar_cliente.php">➕ Agregar Cliente</a></li>
      <li><a href="listar_cliente.php">📋 Listar Clientes</a></li>

      <li><strong>🧑‍💼 Conductores</strong></li>
      <li><a href="form_guardar_conductor.php">➕ Agregar Conductor</a></li>
      <li><a href="listar_conductor.php">📋 Listar Conductores</a></li>

      <li><strong>🚚 Vehículos</strong></li>
      <li><a href="form_guardar_vehiculo.php">➕ Agregar Vehículo</a></li>
      <li><a href="listar_vehiculo.php">📋 Listar Vehículos</a></li>

      <li><strong>📦 Pedidos</strong></li>
      <li><a href="form_guardar_pedido.php">➕ Agregar Pedido</a></li>
      <li><a href="listar_pedido.php">📋 Listar Pedidos</a></li>

      <li><strong>🗺️ Rutas</strong></li>
      <li><a href="form_guardar_ruta.php">➕ Agregar Ruta</a></li>
      <li><a href="listar_ruta.php">📋 Listar Rutas</a></li>

      <li><strong>👤 Usuarios</strong></li>
      <li><a href="form_guardar_usuario.php">➕ Agregar Usuario</a></li>
      <li><a href="listar_usuario.php">📋 Listar Usuarios</a></li>

      <li><strong>📑 Personas</strong></li>
      <li><a href="form_guardar_persona.php">➕ Agregar Persona</a></li>
      <li><a href="listar_persona.php">📋 Listar Personas</a></li>

      <li><strong>📊 Reportes</strong></li>
      <li><a href="reporte_ventas.php">🧾 Reporte de Ventas</a></li>
      <li><a href="reporte_clientes.php">📈 Reporte de Clientes</a></li>
      <li><a href="reporte_productos.php">📦 Reporte de Productos</a></li>

      <li><a href="listar_sesion.php">🕒 Sesiones</a></li>
      <li><a href="../BACK/cerrar_sesion.php">🚪 Salir</a></li>
    </ul>
  </nav>
</aside>

<main class = 'contenido'>
<div class="formulario-box">
    <h2>✏️ Editar Producto</h2>
    <form method="POST" class="formulario-editar-producto">
        <div class="form-group">
            <label>Nombre:
                <input type="text" name="v_pro_nombre" value="<?= $producto['v_pro_nombre'] ?>" required>
            </label>
            <label>Volumen (cm³):
                <input type="number" name="i_pro_volumen" value="<?= $producto['i_pro_volumen'] ?>" required>
            </label>
            <label>Precio (S/):
                <input type="number" step="0.01" name="d_pro_precio" value="<?= $producto['d_pro_precio'] ?>" required>
            </label>
        </div>

        <div class="form-actions">
            <button type="submit" name="actualizar" class="btn-success">💾 Actualizar</button>
        </div>
    </form>

    <a href="listar_producto.php" class="volver-enlace">← Volver al listado</a>
</div>






</main>
</div>

</body>

</html>