<?php
require_once '../BACK/controlador_pedido.php';
$controlador = new ControladorPedido();

if (!isset($_GET['editar'])) {
    header("Location: listar_pedido.php");
    exit();
}

$idPedido = $_GET['editar'];
$detalles = $controlador->obtenerDetallesPedido($idPedido);
$productos = $controlador->obtenerProductos();

if (isset($_POST['actualizar'])) {
    $nuevosProductos = [];
    foreach ($_POST['productos'] as $i => $id_pro) {
        $nuevosProductos[] = [
            'id_pro' => intval($id_pro),
            'cantidad' => intval($_POST['cantidades'][$i])
        ];
    }

    $controlador->actualizarPedido($idPedido, $nuevosProductos);
    header("Location: listar_pedido.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang = 'es'>

<head>
<meta charset = 'UTF-8' />
<meta name = 'viewport' content = 'width=device-width, initial-scale=1.0' />
<title>Encabezado y Barra Lateral Fijos</title>
<link rel = 'stylesheet' href = '../CSS/barr_enc.css'>
<link rel = 'stylesheet' href = '../CSS/editar_pedido.css'>
</head>

<body>

<header>
<div class = 'empresa'>
<img src = '../IMG/logo_actual.png' alt = 'Logo' class = 'logo'>
<span>TRANSOLAM</span>
</div>

</header>

<div class = 'contenedor'>
<aside class="sidebar">
  <nav>
    <ul>
      <li><a href="index.php">🏠 Inicio</a></li>

      <li><strong>📦 Productos</strong></li>
      <li><a href="form_guardar_producto.php">➕ Agregar Producto</a></li>
      <li><a href="listar_producto.php">📋 Listar Productos</a></li>

      <li><strong>👥 Clientes</strong></li>
      <li><a href="form_guardar_cliente.php">➕ Agregar Cliente</a></li>
      <li><a href="listar_cliente.php">📋 Listar Clientes</a></li>

      <li><strong>🧑‍💼 Conductores</strong></li>
      <li><a href="form_guardar_conductor.php">➕ Agregar Conductor</a></li>
      <li><a href="listar_conductor.php">📋 Listar Conductores</a></li>

      <li><strong>🚚 Vehículos</strong></li>
      <li><a href="form_guardar_vehiculo.php">➕ Agregar Vehículo</a></li>
      <li><a href="listar_vehiculo.php">📋 Listar Vehículos</a></li>

      <li><strong>📦 Pedidos</strong></li>
      <li><a href="form_guardar_pedido.php">➕ Agregar Pedido</a></li>
      <li><a href="listar_pedido.php">📋 Listar Pedidos</a></li>

      <li><strong>🗺️ Rutas</strong></li>
      <li><a href="form_guardar_ruta.php">➕ Agregar Ruta</a></li>
      <li><a href="listar_ruta.php">📋 Listar Rutas</a></li>

      <li><strong>👤 Usuarios</strong></li>
      <li><a href="form_guardar_usuario.php">➕ Agregar Usuario</a></li>
      <li><a href="listar_usuario.php">📋 Listar Usuarios</a></li>

      <li><strong>📑 Personas</strong></li>
      <li><a href="form_guardar_persona.php">➕ Agregar Persona</a></li>
      <li><a href="listar_persona.php">📋 Listar Personas</a></li>

      <li><strong>📊 Reportes</strong></li>
      <li><a href="reporte_ventas.php">🧾 Reporte de Ventas</a></li>
      <li><a href="reporte_clientes.php">📈 Reporte de Clientes</a></li>
      <li><a href="reporte_productos.php">📦 Reporte de Productos</a></li>

      <li><a href="listar_sesion.php">🕒 Sesiones</a></li>
      <li><a href="../BACK/cerrar_sesion.php">🚪 Salir</a></li>
    </ul>
  </nav>
</aside>

<main class = 'contenido'>
<div class="formulario-box">
    <h2>✏️ Editar Pedido</h2>
    <form method="POST" class="formulario-editar-pedido">
        <div id="productos" class="productos-container">
            <?php foreach ($detalles as $det): ?>
                <div class="producto-item">
                    <select name="productos[]">
                        <?php foreach ($productos as $pro): ?>
                            <option value="<?= $pro['i_pro_id'] ?>" <?= $pro['i_pro_id'] == $det['i_dpe_id_pro'] ? 'selected' : '' ?>>
                                <?= $pro['v_pro_nombre'] ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <input type="number" name="cantidades[]" value="<?= $det['i_dpe_cantidad'] ?>" required>
                </div>
            <?php endforeach; ?>
        </div>
        <div class="form-actions">
            <button type="button" onclick="agregarProducto()" class="btn-outline">➕ Agregar Producto</button>
            <button type="submit" name="actualizar" class="btn-success">💾 Actualizar Pedido</button>
        </div>
    </form>
    <a href="listar_pedido.php" class="volver-enlace">← Volver</a>
</div>




</main>
</div>
<script>
function agregarProducto() {
    const div = document.createElement('div');
    div.innerHTML = `<?= "<select name='productos[]'>" .
        implode('', array_map(fn($p) => "<option value='{$p['i_pro_id']}'>{$p['v_pro_nombre']}</option>", $productos)) .
        "</select>" ?> <input type="number" name="cantidades[]" required>`;
    document.getElementById('productos').appendChild(div);
}
</script>
</body>

</html>