<?php
require_once '../BACK/controlador_cliente.php';
$controlador = new ControladorCliente();

if (!isset($_GET['editar'])) {
    header("Location: listar_cliente.php");
    exit();
}

$id = $_GET['editar'];
$cliente = $controlador->obtenerClientePorId($id);
$personas = $controlador->obtenerPersonas();

if (isset($_POST['actualizar'])) {
    $controlador->actualizarCliente(
        $id,
        $_POST['i_cli_id_per'],
        $_POST['v_cli_direccion'],
        $_POST['i_cli_latitud'],
        $_POST['i_cli_longitud']
    );
    header("Location: listar_cliente.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang = 'es'>

<head>
<meta charset = 'UTF-8' />
<meta name = 'viewport' content = 'width=device-width, initial-scale=1.0' />
<title>Encabezado y Barra Lateral Fijos</title>
<link rel = 'stylesheet' href = '../CSS/barr_enc.css'>
<link rel = 'stylesheet' href = '../CSS/editar_cliente.css'>
</head>

<body>

<header>
<div class = 'empresa'>
<img src = '../IMG/logo_actual.png' alt = 'Logo' class = 'logo'>
<span>TRANSOLAM</span>
</div>

</header>

<div class = 'contenedor'>
<aside class="sidebar">
  <nav>
    <ul>
      <li><a href="index.php">🏠 Inicio</a></li>

      <li><strong>📦 Productos</strong></li>
      <li><a href="form_guardar_producto.php">➕ Agregar Producto</a></li>
      <li><a href="listar_producto.php">📋 Listar Productos</a></li>

      <li><strong>👥 Clientes</strong></li>
      <li><a href="form_guardar_cliente.php">➕ Agregar Cliente</a></li>
      <li><a href="listar_cliente.php">📋 Listar Clientes</a></li>

      <li><strong>🧑‍💼 Conductores</strong></li>
      <li><a href="form_guardar_conductor.php">➕ Agregar Conductor</a></li>
      <li><a href="listar_conductor.php">📋 Listar Conductores</a></li>

      <li><strong>🚚 Vehículos</strong></li>
      <li><a href="form_guardar_vehiculo.php">➕ Agregar Vehículo</a></li>
      <li><a href="listar_vehiculo.php">📋 Listar Vehículos</a></li>

      <li><strong>📦 Pedidos</strong></li>
      <li><a href="form_guardar_pedido.php">➕ Agregar Pedido</a></li>
      <li><a href="listar_pedido.php">📋 Listar Pedidos</a></li>

      <li><strong>🗺️ Rutas</strong></li>
      <li><a href="form_guardar_ruta.php">➕ Agregar Ruta</a></li>
      <li><a href="listar_ruta.php">📋 Listar Rutas</a></li>

      <li><strong>👤 Usuarios</strong></li>
      <li><a href="form_guardar_usuario.php">➕ Agregar Usuario</a></li>
      <li><a href="listar_usuario.php">📋 Listar Usuarios</a></li>

      <li><strong>📑 Personas</strong></li>
      <li><a href="form_guardar_persona.php">➕ Agregar Persona</a></li>
      <li><a href="listar_persona.php">📋 Listar Personas</a></li>

      <li><strong>📊 Reportes</strong></li>
      <li><a href="reporte_ventas.php">🧾 Reporte de Ventas</a></li>
      <li><a href="reporte_clientes.php">📈 Reporte de Clientes</a></li>
      <li><a href="reporte_productos.php">📦 Reporte de Productos</a></li>

      <li><a href="listar_sesion.php">🕒 Sesiones</a></li>
      <li><a href="../BACK/cerrar_sesion.php">🚪 Salir</a></li>
    </ul>
  </nav>
</aside>

<main class = 'contenido'>
<div class="formulario-box">
    <h2>✏️ Editar Cliente</h2>
    <form method="POST" class="formulario-editar-cliente">
        <div class="form-group">
            <label>Persona:
                <select name="i_cli_id_per" required>
                    <?php foreach ($personas as $p): ?>
                        <option value="<?= $p['i_per_id'] ?>" <?= ($cliente['i_cli_id_per'] == $p['i_per_id']) ? 'selected' : '' ?>>
                            <?= $p['v_per_nombres'] . ' ' . $p['v_per_apellido_p'] . ' ' . $p['v_per_apellido_m'] ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </label>
            <label>Dirección:
                <input type="text" name="v_cli_direccion" value="<?= $cliente['v_cli_direccion'] ?>" required>
            </label>
            <label>Latitud:
                <input type="number" name="i_cli_latitud" value="<?= $cliente['i_cli_latitud'] ?>" required>
            </label>
            <label>Longitud:
                <input type="number" name="i_cli_longitud" value="<?= $cliente['i_cli_longitud'] ?>" required>
            </label>
        </div>

        <div class="form-actions">
            <button type="submit" name="actualizar" class="btn-success">💾 Actualizar</button>
        </div>
    </form>

    <a href="listar_cliente.php" class="volver-enlace">← Volver al listado</a>
</div>



</main>
</div>

</body>

</html>