<?php
require_once '../CONEXION/conexion.php';
// Aquí debe estar tu clase Conexion con MySQLi

class ControladorPersona {

    private $conn;

    public function __construct() {
        $this->conn = Conexion::obtenerConexion();
        // Retorna una instancia de mysqli
    }

    // Crear nueva persona

    public function crearPersona( $nombres, $apellido_p, $apellido_m, $tipoDocumento, $documento, $telefono ) {
        $stmt = $this->conn->prepare( "INSERT INTO tm_persona 
        (v_per_nombres, v_per_apellido_p, v_per_apellido_m, i_per_tipoDocumento, v_per_documento, v_per_telefono)
        VALUES (?, ?, ?, ?, ?, ?)" );
        $stmt->bind_param( 'ssssss', $nombres, $apellido_p, $apellido_m, $tipoDocumento, $documento, $telefono );
        return $stmt->execute();
    }

    // Obtener todas las personas

    public function obtenerPersonas() {
        $result = $this->conn->query( 'SELECT * FROM tm_persona' );
        $personas = [];
        while ( $row = $result->fetch_assoc() ) {
            $personas[] = $row;
        }
        return $personas;
    }

    // Obtener persona por ID

    public function obtenerPersonaPorId( $id ) {
        $stmt = $this->conn->prepare( 'SELECT * FROM tm_persona WHERE i_per_id = ?' );
        $stmt->bind_param( 'i', $id );
        $stmt->execute();
        $resultado = $stmt->get_result();
        return $resultado->fetch_assoc();
    }

    // Actualizar persona

    public function actualizarPersona( $id, $nombres, $apellido_p, $apellido_m, $tipoDocumento, $documento, $telefono ) {
        $stmt = $this->conn->prepare( "UPDATE tm_persona SET 
        v_per_nombres = ?, 
        v_per_apellido_p = ?, 
        v_per_apellido_m = ?, 
        i_per_tipoDocumento = ?, 
        v_per_documento = ?, 
        v_per_telefono = ?
        WHERE i_per_id = ?" );
        $stmt->bind_param( 'ssssssi', $nombres, $apellido_p, $apellido_m, $tipoDocumento, $documento, $telefono, $id );
        return $stmt->execute();
    }

    // Eliminar persona

    public function eliminarPersona( $id ) {
        $stmt = $this->conn->prepare( 'DELETE FROM tm_persona WHERE i_per_id = ?' );
        $stmt->bind_param( 'i', $id );
        return $stmt->execute();
    }
}
?>
