<?php
session_start();
require_once '../CONEXION/conexion.php';

class ControladorLogin {
    private $conn;

    public function __construct() {
        $this->conn = Conexion::obtenerConexion();
    }

    public function validarUsuario( $correo, $clave ) {
        $stmt = $this->conn->prepare( 'SELECT * FROM tm_usuario WHERE v_usu_correo = ? AND i_usu_estado = 1' );
        $stmt->bind_param( 's', $correo );
        $stmt->execute();
        $resultado = $stmt->get_result();

        if ( $resultado->num_rows == 1 ) {
            $usuario = $resultado->fetch_assoc();

            if ( password_verify( $clave, $usuario[ 'v_usu_clave' ] ) ) {
                // Guardar sesión en la base de datos
                $token = bin2hex( random_bytes( 16 ) );
                $fechaAcceso = date( 'Y-m-d H:i:s' );
                $estado = 1;

                $stmtSesion = $this->conn->prepare( "INSERT INTO tl_sesion (i_ses_id_usu, v_ses_token, d_ses_fechaHoraAcceso, d_ses_fechaHoraSalida, i_ses_estado) 
                                                    VALUES (?, ?, ?, ?, ?)" );
                $stmtSesion->bind_param( 'isssi', $usuario[ 'i_usu_id' ], $token, $fechaAcceso, $fechaAcceso, $estado );
                $stmtSesion->execute();
                $idSesion = $this->conn->insert_id;

                // Guardar en variables de sesión
                $_SESSION[ 'id_usuario' ] = $usuario[ 'i_usu_id' ];
                $_SESSION[ 'correo' ] = $usuario[ 'v_usu_correo' ];
                $_SESSION[ 'token' ] = $token;
                $_SESSION[ 'id_sesion' ] = $idSesion;

                return true;
            }
        }

        return false;
    }
}
?>
