<?php
require_once '../CONEXION/conexion.php';

class ControladorVehiculo {
    private $conn;

    public function __construct() {
        $this->conn = Conexion::obtenerConexion();
    }

    public function crearVehiculo( $idConductor, $placa, $volumen ) {
        $stmt = $this->conn->prepare( 'INSERT INTO tm_vehiculo (i_veh_id_con, v_veh_placa, i_veh_volumen) VALUES (?, ?, ?)' );
        $stmt->bind_param( 'isi', $idConductor, $placa, $volumen );
        return $stmt->execute();
    }

    public function obtenerVehiculos() {
        $sql = "SELECT v.*, p.v_per_nombres, p.v_per_apellido_p, p.v_per_apellido_m
                FROM tm_vehiculo v
                INNER JOIN tm_conductor c ON v.i_veh_id_con = c.i_con_id
                INNER JOIN tm_persona p ON c.i_con_id_per = p.i_per_id";
        $res = $this->conn->query( $sql );
        return $res->fetch_all( MYSQLI_ASSOC );
    }

    public function obtenerVehiculoPorId( $id ) {
        $stmt = $this->conn->prepare( 'SELECT * FROM tm_vehiculo WHERE i_veh_id = ?' );
        $stmt->bind_param( 'i', $id );
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    public function actualizarVehiculo( $id, $idConductor, $placa, $volumen ) {
        $stmt = $this->conn->prepare( 'UPDATE tm_vehiculo SET i_veh_id_con = ?, v_veh_placa = ?, i_veh_volumen = ? WHERE i_veh_id = ?' );
        $stmt->bind_param( 'isii', $idConductor, $placa, $volumen, $id );
        return $stmt->execute();
    }

    public function eliminarVehiculo( $id ) {
        $stmt = $this->conn->prepare( 'DELETE FROM tm_vehiculo WHERE i_veh_id = ?' );
        $stmt->bind_param( 'i', $id );
        return $stmt->execute();
    }

    public function obtenerConductores() {
        $res = $this->conn->query( "SELECT c.i_con_id, p.v_per_nombres, p.v_per_apellido_p, p.v_per_apellido_m
                                   FROM tm_conductor c
                                   INNER JOIN tm_persona p ON c.i_con_id_per = p.i_per_id" );
        return $res->fetch_all( MYSQLI_ASSOC );
    }
}
?>
