<?php
require_once '../CONEXION/conexion.php';

class ControladorUsuario {
    private $conn;

    public function __construct() {
        $this->conn = Conexion::obtenerConexion();
    }

    public function crearUsuario( $idPersona, $correo, $clave, $tipo, $estado ) {
        $hash = password_hash( $clave, PASSWORD_DEFAULT );
        $stmt = $this->conn->prepare( "INSERT INTO tm_usuario (i_usu_id_per, v_usu_correo, v_usu_clave, i_usu_tipo, i_usu_estado)
                                      VALUES (?, ?, ?, ?, ?)" );
        $stmt->bind_param( 'issii', $idPersona, $correo, $hash, $tipo, $estado );
        return $stmt->execute();
    }

    public function obtenerUsuarios() {
        $sql = "SELECT u.*, p.v_per_nombres, p.v_per_apellido_p, p.v_per_apellido_m
                FROM tm_usuario u
                INNER JOIN tm_persona p ON u.i_usu_id_per = p.i_per_id";
        $res = $this->conn->query( $sql );
        return $res->fetch_all( MYSQLI_ASSOC );
    }

    public function obtenerUsuarioPorId( $id ) {
        $stmt = $this->conn->prepare( 'SELECT * FROM tm_usuario WHERE i_usu_id = ?' );
        $stmt->bind_param( 'i', $id );
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    public function actualizarUsuario( $id, $idPersona, $correo, $clave, $tipo, $estado ) {
        if ( !empty( $clave ) ) {
            $hash = password_hash( $clave, PASSWORD_DEFAULT );
            $stmt = $this->conn->prepare( 'UPDATE tm_usuario SET i_usu_id_per = ?, v_usu_correo = ?, v_usu_clave = ?, i_usu_tipo = ?, i_usu_estado = ? WHERE i_usu_id = ?' );
            $stmt->bind_param( 'issiii', $idPersona, $correo, $hash, $tipo, $estado, $id );
        } else {
            $stmt = $this->conn->prepare( 'UPDATE tm_usuario SET i_usu_id_per = ?, v_usu_correo = ?, i_usu_tipo = ?, i_usu_estado = ? WHERE i_usu_id = ?' );
            $stmt->bind_param( 'isiii', $idPersona, $correo, $tipo, $estado, $id );
        }
        return $stmt->execute();
    }

    public function eliminarUsuario( $id ) {
        $stmt = $this->conn->prepare( 'DELETE FROM tm_usuario WHERE i_usu_id = ?' );
        $stmt->bind_param( 'i', $id );
        return $stmt->execute();
    }

    public function obtenerPersonas() {
        $res = $this->conn->query( 'SELECT i_per_id, v_per_nombres, v_per_apellido_p, v_per_apellido_m FROM tm_persona' );
        return $res->fetch_all( MYSQLI_ASSOC );
    }
}
?>
