<?php
require_once '../CONEXION/conexion.php';

class ControladorRuta {
    private $conn;

    public function __construct() {
        $this->conn = Conexion::obtenerConexion();
    }

    public function obtenerVehiculos() {
        $res = $this->conn->query("SELECT v.i_veh_id, v.v_veh_placa, p.v_per_nombres 
                                   FROM tm_vehiculo v 
                                   JOIN tm_conductor c ON v.i_veh_id_con = c.i_con_id 
                                   JOIN tm_persona p ON c.i_con_id_per = p.i_per_id");
        return $res->fetch_all(MYSQLI_ASSOC);
    }

    public function obtenerDetallesPedidoDisponibles() {
        $res = $this->conn->query("SELECT d.i_dpe_id, pr.v_pro_nombre, d.i_dpe_cantidad 
                                   FROM td_pedido d 
                                   JOIN tm_producto pr ON d.i_dpe_id_pro = pr.i_pro_id 
                                   WHERE d.i_dpe_id NOT IN (SELECT i_dru_id_dpe FROM td_ruta)");
        return $res->fetch_all(MYSQLI_ASSOC);
    }

    public function crearRuta($idVehiculo, $detalles) {
        $this->conn->begin_transaction();

        $stmt = $this->conn->prepare("INSERT INTO th_ruta (i_rut_id_veh, d_rut_fecha) VALUES (?, NOW())");
        $stmt->bind_param('i', $idVehiculo);
        $stmt->execute();
        $rutaId = $this->conn->insert_id;

        $stmtDetalle = $this->conn->prepare("INSERT INTO td_ruta (i_dru_id, i_dru_id_dpe) VALUES (?, ?)");
        foreach ($detalles as $idDetalle) {
            $stmtDetalle->bind_param("ii", $rutaId, $idDetalle);
            $stmtDetalle->execute();
        }

        $this->conn->commit();
        return true;
    }

    public function obtenerRutas() {
        $sql = "SELECT r.i_rut_id, r.d_rut_fecha, v.v_veh_placa, p.v_per_nombres
                FROM th_ruta r
                JOIN tm_vehiculo v ON r.i_rut_id_veh = v.i_veh_id
                JOIN tm_conductor c ON v.i_veh_id_con = c.i_con_id
                JOIN tm_persona p ON c.i_con_id_per = p.i_per_id
                ORDER BY r.d_rut_fecha DESC";
        return $this->conn->query($sql)->fetch_all(MYSQLI_ASSOC);
    }

    public function obtenerRutaPorId($id) {
        $stmt = $this->conn->prepare("SELECT * FROM th_ruta WHERE i_rut_id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    public function obtenerDetallesRuta($idRuta) {
        $sql = "SELECT d.i_dru_id_dpe, pr.v_pro_nombre, td.i_dpe_cantidad 
                FROM td_ruta d 
                JOIN td_pedido td ON d.i_dru_id_dpe = td.i_dpe_id
                JOIN tm_producto pr ON td.i_dpe_id_pro = pr.i_pro_id
                WHERE d.i_dru_id = ?";
        $stmt = $this->conn->prepare($sql);
        $stmt->bind_param("i", $idRuta);
        $stmt->execute();
        return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    }

    public function actualizarRuta($idRuta, $detalles) {
        $this->conn->begin_transaction();

        $this->conn->query("DELETE FROM td_ruta WHERE i_dru_id = $idRuta");

        $stmt = $this->conn->prepare("INSERT INTO td_ruta (i_dru_id, i_dru_id_dpe) VALUES (?, ?)");
        foreach ($detalles as $idDetalle) {
            $stmt->bind_param("ii", $idRuta, $idDetalle);
            $stmt->execute();
        }

        $this->conn->commit();
        return true;
    }

    public function eliminarRuta($idRuta) {
        $this->conn->query("DELETE FROM td_ruta WHERE i_dru_id = $idRuta");
        return $this->conn->query("DELETE FROM th_ruta WHERE i_rut_id = $idRuta");
    }
}
?>
