<?php
require_once '../CONEXION/conexion.php';

class ControladorProducto {
    private $conn;

    public function __construct() {
        $this->conn = Conexion::obtenerConexion();
    }

    public function crearProducto($nombre, $volumen, $precio) {
        $stmt = $this->conn->prepare("INSERT INTO tm_producto (v_pro_nombre, i_pro_volumen, d_pro_precio) VALUES (?, ?, ?)");
        $stmt->bind_param('sid', $nombre, $volumen, $precio);
        return $stmt->execute();
    }

    public function obtenerProductos() {
        $res = $this->conn->query("SELECT * FROM tm_producto");
        return $res->fetch_all(MYSQLI_ASSOC);
    }

    public function obtenerProductoPorId($id) {
        $stmt = $this->conn->prepare("SELECT * FROM tm_producto WHERE i_pro_id = ?");
        $stmt->bind_param('i', $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    public function actualizarProducto($id, $nombre, $volumen, $precio) {
        $stmt = $this->conn->prepare("UPDATE tm_producto SET v_pro_nombre = ?, i_pro_volumen = ?, d_pro_precio = ? WHERE i_pro_id = ?");
        $stmt->bind_param('sidi', $nombre, $volumen, $precio, $id);
        return $stmt->execute();
    }

    public function eliminarProducto($id) {
        $stmt = $this->conn->prepare("DELETE FROM tm_producto WHERE i_pro_id = ?");
        $stmt->bind_param('i', $id);
        return $stmt->execute();
    }
}
?>
