<?php
require_once '../CONEXION/conexion.php';

class ControladorPedido {
    private $conn;

    public function __construct() {
        $this->conn = Conexion::obtenerConexion();
    }

    public function obtenerClientes() {
        $res = $this->conn->query("SELECT c.i_cli_id, p.v_per_nombres, p.v_per_apellido_p 
                                   FROM tm_cliente c 
                                   JOIN tm_persona p ON c.i_cli_id_per = p.i_per_id");
        return $res->fetch_all(MYSQLI_ASSOC);
    }

    public function obtenerProductos() {
        $res = $this->conn->query("SELECT * FROM tm_producto");
        return $res->fetch_all(MYSQLI_ASSOC);
    }

    public function crearPedido($idCliente, $productos) {
        $this->conn->begin_transaction();

        $stmt = $this->conn->prepare("INSERT INTO th_pedido (i_ped_id_cli, i_ped_fecha) VALUES (?, NOW())");
        $stmt->bind_param('i', $idCliente);
        $stmt->execute();
        $pedidoId = $this->conn->insert_id;

        $stmtDetalle = $this->conn->prepare("INSERT INTO td_pedido (i_dpe_id_ped, i_dpe_id_pro, i_dpe_cantidad) VALUES (?, ?, ?)");
        foreach ($productos as $producto) {
            $stmtDetalle->bind_param('iii', $pedidoId, $producto['id_pro'], $producto['cantidad']);
            $stmtDetalle->execute();
        }

        $this->conn->commit();
        return true;
    }

    public function obtenerPedidos() {
        $sql = "SELECT p.i_ped_id, p.i_ped_fecha, per.v_per_nombres, per.v_per_apellido_p
                FROM th_pedido p
                JOIN tm_cliente c ON p.i_ped_id_cli = c.i_cli_id
                JOIN tm_persona per ON c.i_cli_id_per = per.i_per_id
                ORDER BY p.i_ped_fecha DESC";
        return $this->conn->query($sql)->fetch_all(MYSQLI_ASSOC);
    }

    public function obtenerDetallesPedido($idPedido) {
        $sql = "SELECT d.*, pr.v_pro_nombre 
                FROM td_pedido d 
                JOIN tm_producto pr ON d.i_dpe_id_pro = pr.i_pro_id 
                WHERE d.i_dpe_id_ped = ?";
        $stmt = $this->conn->prepare($sql);
        $stmt->bind_param('i', $idPedido);
        $stmt->execute();
        return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
    }

    public function eliminarPedido($id) {
        $this->conn->query("DELETE FROM td_pedido WHERE i_dpe_id_ped = $id");
        return $this->conn->query("DELETE FROM th_pedido WHERE i_ped_id = $id");
    }

    public function obtenerPedidoPorId($id) {
        $stmt = $this->conn->prepare("SELECT * FROM th_pedido WHERE i_ped_id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    public function actualizarPedido($idPedido, $productos) {
        $this->conn->begin_transaction();
        $this->conn->query("DELETE FROM td_pedido WHERE i_dpe_id_ped = $idPedido");

        $stmt = $this->conn->prepare("INSERT INTO td_pedido (i_dpe_id_ped, i_dpe_id_pro, i_dpe_cantidad) VALUES (?, ?, ?)");
        foreach ($productos as $producto) {
            $stmt->bind_param("iii", $idPedido, $producto['id_pro'], $producto['cantidad']);
            $stmt->execute();
        }

        $this->conn->commit();
        return true;
    }
}
?>
