<?php
require_once '../CONEXION/conexion.php';

class ControladorConductor {
    private $conn;

    public function __construct() {
        $this->conn = Conexion::obtenerConexion();
    }

    public function crearConductor($idPersona, $licencia) {
        $stmt = $this->conn->prepare("INSERT INTO tm_conductor (i_con_id_per, v_con_licencia) VALUES (?, ?)");
        $stmt->bind_param('is', $idPersona, $licencia);
        return $stmt->execute();
    }

    public function obtenerConductores() {
        $sql = "SELECT c.*, p.v_per_nombres, p.v_per_apellido_p, p.v_per_apellido_m
                FROM tm_conductor c
                INNER JOIN tm_persona p ON c.i_con_id_per = p.i_per_id";
        $res = $this->conn->query($sql);
        return $res->fetch_all(MYSQLI_ASSOC);
    }

    public function obtenerConductorPorId($id) {
        $stmt = $this->conn->prepare("SELECT * FROM tm_conductor WHERE i_con_id = ?");
        $stmt->bind_param('i', $id);
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    public function actualizarConductor($id, $idPersona, $licencia) {
        $stmt = $this->conn->prepare("UPDATE tm_conductor SET i_con_id_per = ?, v_con_licencia = ? WHERE i_con_id = ?");
        $stmt->bind_param('isi', $idPersona, $licencia, $id);
        return $stmt->execute();
    }

    public function eliminarConductor($id) {
        $stmt = $this->conn->prepare("DELETE FROM tm_conductor WHERE i_con_id = ?");
        $stmt->bind_param('i', $id);
        return $stmt->execute();
    }

    public function obtenerPersonas() {
        $res = $this->conn->query("SELECT i_per_id, v_per_nombres, v_per_apellido_p, v_per_apellido_m FROM tm_persona");
        return $res->fetch_all(MYSQLI_ASSOC);
    }
}
?>
