<?php
require_once '../CONEXION/conexion.php';

class ControladorCliente {
    private $conn;

    public function __construct() {
        $this->conn = Conexion::obtenerConexion();
    }

    public function crearCliente( $idPersona, $direccion, $latitud, $longitud ) {
        $stmt = $this->conn->prepare( 'INSERT INTO tm_cliente (i_cli_id_per, v_cli_direccion, i_cli_latitud, i_cli_longitud) VALUES (?, ?, ?, ?)' );
        $stmt->bind_param( 'isii', $idPersona, $direccion, $latitud, $longitud );
        return $stmt->execute();
    }

    public function obtenerClientes() {
        $sql = "SELECT c.*, p.v_per_nombres, p.v_per_apellido_p, p.v_per_apellido_m
                FROM tm_cliente c
                INNER JOIN tm_persona p ON c.i_cli_id_per = p.i_per_id";
        $result = $this->conn->query( $sql );
        $clientes = [];
        while ( $row = $result->fetch_assoc() ) {
            $clientes[] = $row;
        }
        return $clientes;
    }

    public function obtenerClientePorId( $id ) {
        $stmt = $this->conn->prepare( 'SELECT * FROM tm_cliente WHERE i_cli_id = ?' );
        $stmt->bind_param( 'i', $id );
        $stmt->execute();
        return $stmt->get_result()->fetch_assoc();
    }

    public function actualizarCliente( $id, $idPersona, $direccion, $latitud, $longitud ) {
        $stmt = $this->conn->prepare( "UPDATE tm_cliente SET 
            i_cli_id_per = ?, v_cli_direccion = ?, i_cli_latitud = ?, i_cli_longitud = ?
            WHERE i_cli_id = ?" );
        $stmt->bind_param( 'isiii', $idPersona, $direccion, $latitud, $longitud, $id );
        return $stmt->execute();
    }

    public function eliminarCliente( $id ) {
        $stmt = $this->conn->prepare( 'DELETE FROM tm_cliente WHERE i_cli_id = ?' );
        $stmt->bind_param( 'i', $id );
        return $stmt->execute();
    }

    // Para llenar combo de personas

    public function obtenerPersonas() {
        $res = $this->conn->query( 'SELECT i_per_id, v_per_nombres, v_per_apellido_p, v_per_apellido_m FROM tm_persona' );
        return $res->fetch_all( MYSQLI_ASSOC );
    }
}
?>
