<?php
header( 'Content-Type: application/json' );
require_once '../CBDDCM/conexion.php';

function guardarLog( $accion, $datos ) {
    $logFile = __DIR__ . '/log.txt';
    $fecha = date( 'Y-m-d H:i:s' );
    $contenido = "[$fecha] Acción: $accion\nDatos: " . print_r( $datos, true ) . '\n----------------------\n';
    file_put_contents( $logFile, $contenido, FILE_APPEND );
}

$accion = $_GET[ 'accion' ] ?? '';
$conexion = Conexion::obtenerConexion();

switch ( $accion ) {
    case 'listar':
    $sql = "SELECT t.id_tela, t.tela, 
                    GROUP_CONCAT(tc.id_composicion) AS ids_composiciones,
                    GROUP_CONCAT(c.composicion) AS composiciones,
                    GROUP_CONCAT(tc.cantidad) AS cantidades
                FROM telas t
                LEFT JOIN tela_composicion tc ON t.id_tela = tc.id_tela
                LEFT JOIN composiciones c ON tc.id_composicion = c.id_composicion
                GROUP BY t.id_tela
                ORDER BY t.id_tela DESC";

    $result = $conexion->query( $sql );
    $telas = [];
    while ( $row = $result->fetch_assoc() ) {
        $telas[] = $row;
    }
    echo json_encode( $telas );
    guardarLog( 'listar', [] );
    break;

    case 'registrar':
    $datos = json_decode( file_get_contents( 'php://input' ), true );
    $tela = $conexion->real_escape_string( $datos[ 'tela' ] ?? '' );
    $composiciones = $datos[ 'composiciones' ] ?? [];

    if ( !$tela || empty( $composiciones ) ) {
        echo json_encode( [ 'error' => 'Datos incompletos o inválidos' ] );
        exit;
    }

    $conexion->begin_transaction();
    try {
        // Insertar tela
        $conexion->query( "INSERT INTO telas (tela) VALUES ('$tela')" );
        $id_tela = $conexion->insert_id;

        // Insertar composiciones con cantidades
        $stmt = $conexion->prepare( 'INSERT INTO tela_composicion (id_tela, id_composicion, cantidad) VALUES (?, ?, ?)' );
        foreach ( $composiciones as $comp ) {
            $id_compo = intval( $comp[ 'id_composicion' ] );
            $cant = floatval( $comp[ 'cantidad' ] );
            $stmt->bind_param( 'iid', $id_tela, $id_compo, $cant );
            $stmt->execute();
        }

        $conexion->commit();
        echo json_encode( [ 'mensaje' => 'Tela registrada correctamente' ] );
    } catch ( Exception $e ) {
        $conexion->rollback();
        echo json_encode( [ 'error' => 'Error al registrar: ' . $e->getMessage() ] );
    }
    break;

    case 'editar':
    $datos = json_decode( file_get_contents( 'php://input' ), true );
    guardarLog( 'editar', $datos );

    $id_tela = intval( $datos[ 'id_tela' ] ?? 0 );
    $tela = $conexion->real_escape_string( $datos[ 'tela' ] ?? '' );
    $ids = $datos[ 'ids_composiciones' ] ?? [];
    $cantidades = $datos[ 'cantidades' ] ?? [];

    if ( !$id_tela || !$tela || empty( $ids ) || empty( $cantidades ) || count( $ids ) !== count( $cantidades ) ) {
        echo json_encode( [ 'error' => 'Datos incompletos o inválidos' ] );
        exit;
    }

    $conexion->begin_transaction();
    try {
        $conexion->query( "UPDATE telas SET tela = '$tela' WHERE id_tela = $id_tela" );
        $conexion->query( "DELETE FROM tela_composicion WHERE id_tela = $id_tela" );

        $stmt = $conexion->prepare( 'INSERT INTO tela_composicion (id_tela, id_composicion, cantidad) VALUES (?, ?, ?)' );
        foreach ( $ids as $index => $id_compo ) {
            $cant = floatval( $cantidades[ $index ] );
            $stmt->bind_param( 'iid', $id_tela, $id_compo, $cant );
            $stmt->execute();
        }

        $conexion->commit();
        echo json_encode( [ 'mensaje' => 'Tela actualizada correctamente' ] );
    } catch ( Exception $e ) {
        $conexion->rollback();
        echo json_encode( [ 'error' => 'Error al actualizar: ' . $e->getMessage() ] );
    }
    break;

    case 'eliminar':
    $id = intval( $_GET[ 'id' ] ?? 0 );
    guardarLog( 'eliminar', [ 'id' => $id ] );

    if ( !$id ) {
        echo json_encode( [ 'error' => 'ID inválido' ] );
        exit;
    }

    $conexion->query( "DELETE FROM telas WHERE id_tela = $id" );
    echo json_encode( [ 'mensaje' => 'Tela eliminada correctamente' ] );
    break;

    default:
    guardarLog( 'accion_no_valida', $_GET );
    echo json_encode( [ 'error' => 'Acción no válida' ] );
    break;
}
