<?php
header( 'Content-Type: application/json' );
require_once '../CBDDCM/conexion.php';
// Asegúrate de que esté bien la ruta

$accion = $_GET[ 'accion' ] ?? '';
$conexion = Conexion::obtenerConexion();

function guardarLog( $accion, $datos ) {
    $log = '[' . date( 'Y-m-d H:i:s' ) . "] Acción: $accion\nDatos: " . print_r( $datos, true ) . '\n----------------------\n';
    file_put_contents( 'log_tallas.txt', $log, FILE_APPEND );
}

switch ( $accion ) {
    case 'listar_tallas':
    $sql = 'SELECT * FROM tallas ORDER BY id_talla DESC';
    $result = $conexion->query( $sql );
    $tallas = [];

    while ( $row = $result->fetch_assoc() ) {
        $tallas[] = $row;
    }

    echo json_encode( $tallas );
    guardarLog( 'listar_tallas', [] );
    break;

    case 'registrar_talla':
    $data = json_decode( file_get_contents( 'php://input' ), true );
    $talla = $data[ 'talla' ] ?? '';

    if ( $talla === '' ) {
        echo json_encode( [ 'error' => 'La talla no puede estar vacía' ] );
        exit;
    }

    $stmt = $conexion->prepare( 'INSERT INTO tallas (talla) VALUES (?)' );
    $stmt->bind_param( 's', $talla );
    $stmt->execute();

    echo json_encode( [ 'mensaje' => 'Talla registrada correctamente' ] );
    guardarLog( 'registrar_talla', $data );
    break;

    case 'editar_talla':
    $data = json_decode( file_get_contents( 'php://input' ), true );
    $id_talla = $data[ 'id_talla' ] ?? '';
    $talla = $data[ 'talla' ] ?? '';

    if ( $id_talla === '' || $talla === '' ) {
        echo json_encode( [ 'error' => 'Datos incompletos' ] );
        exit;
    }

    $stmt = $conexion->prepare( 'UPDATE tallas SET talla = ? WHERE id_talla = ?' );
    $stmt->bind_param( 'si', $talla, $id_talla );
    $stmt->execute();

    echo json_encode( [ 'mensaje' => 'Talla actualizada correctamente' ] );
    guardarLog( 'editar_talla', $data );
    break;

    case 'eliminar_talla':
    $id = $_GET[ 'id' ] ?? '';
    if ( !$id ) {
        echo json_encode( [ 'error' => 'ID no recibido' ] );
        exit;
    }

    $conexion->query( "DELETE FROM tallas WHERE id_talla = $id" );
    echo json_encode( [ 'mensaje' => 'Talla eliminada' ] );
    guardarLog( 'eliminar_talla', [ 'id' => $id ] );
    break;

    default:
    echo json_encode( [ 'error' => 'Acción no válida' ] );
}
?>
