<?php
require_once '../CBDDCM/conexion.php';
// Asegúrate de que este archivo tenga la función obtenerConexion()

if ( $_SERVER[ 'REQUEST_METHOD' ] === 'POST' ) {
    $dni = $_POST[ 'dni' ] ?? '';
    $correo = $_POST[ 'correo' ] ?? '';
    $contrasena = $_POST[ 'contrasena' ] ?? '';
    $activo = isset( $_POST[ 'activo' ] ) ? ( int )$_POST[ 'activo' ] : 1;

    if ( empty( $dni ) || empty( $correo ) || empty( $contrasena ) ) {
        echo json_encode( [ 'estado' => 'error', 'mensaje' => 'Faltan datos obligatorios' ] );
        exit;
    }

    $conn = Conexion::obtenerConexion();

    // Validar que no se repita el dni ni el correo
    $verificar = $conn->prepare( 'SELECT * FROM usuarios WHERE dni = ? OR correo = ?' );
    $verificar->bind_param( 'ss', $dni, $correo );
    $verificar->execute();
    $resultado = $verificar->get_result();

    if ( $resultado->num_rows > 0 ) {
        echo json_encode( [ 'estado' => 'error', 'mensaje' => 'DNI o correo ya registrados' ] );
        exit;
    }

    // Encriptar contraseña
    $contrasenaHash = password_hash( $contrasena, PASSWORD_DEFAULT );

    $sql = 'INSERT INTO usuarios (dni, correo, contraseña, activo) VALUES (?, ?, ?, ?)';
    $stmt = $conn->prepare( $sql );
    $stmt->bind_param( 'sssi', $dni, $correo, $contrasenaHash, $activo );

    if ( $stmt->execute() ) {
        echo json_encode( [ 'estado' => 'ok', 'mensaje' => 'Usuario registrado correctamente' ] );
    } else {
        echo json_encode( [ 'estado' => 'error', 'mensaje' => 'Error al registrar usuario' ] );
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode( [ 'estado' => 'error', 'mensaje' => 'Método no permitido' ] );
}
