<?php
// Incluir archivo de conexión
require_once '../CBDDCM/conexion.php';

// Establecer encabezado de respuesta JSON
header( 'Content-Type: application/json' );

// Obtener conexión a la base de datos
$conn = Conexion::obtenerConexion();

// Obtener la acción desde POST
$accion = $_POST[ 'accion' ] ?? '';

// Función para obtener imagen binaria

function obtenerImagenBinaria( $inputName ) {
    if ( !isset( $_FILES[ $inputName ] ) || $_FILES[ $inputName ][ 'error' ] !== UPLOAD_ERR_OK ) {
        return null;
    }
    return file_get_contents( $_FILES[ $inputName ][ 'tmp_name' ] ) ?: null;
}

// Función para validar parámetros

function validarParametro( $param ) {
    return isset( $_POST[ $param ] ) ? trim( $_POST[ $param ] ) : null;
}

// Manejo de acciones
try {
    switch ( $accion ) {
        case 'registrar':
        $codigo      = validarParametro( 'codigo' );
        $nombre      = validarParametro( 'nombre' );
        $id_categoria = validarParametro( 'id_categoria' );
        $id_modelo   = validarParametro( 'id_modelo' );
        $id_talla    = validarParametro( 'id_talla' );
        $id_tela     = validarParametro( 'id_tela' );
        $precio      = validarParametro( 'precio' );
        $stock       = validarParametro( 'stock' );
        $imagenBinaria = obtenerImagenBinaria( 'imagen' );

        $stmt = $conn->prepare(
            "INSERT INTO productos 
                (codigo, nombre, id_categoria, id_modelo, id_talla, id_tela, precio, stock, imagen) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)"
        );

        $null = null;
        $stmt->bind_param( 'ssiiiidsb', $codigo, $nombre, $id_categoria, $id_modelo, $id_talla, $id_tela, $precio, $stock, $null );

        if ( $imagenBinaria !== null ) {
            $stmt->send_long_data( 8, $imagenBinaria );
        }

        $resultado = $stmt->execute();

        echo json_encode( [
            'estado' => $resultado ? 'ok' : 'error',
            'mensaje' => $resultado ? 'Producto registrado.' : 'Error: ' . $stmt->error
        ] );
        break;

        case 'listar':
        $sql = "SELECT p.id_producto, p.codigo, p.nombre, p.id_categoria, c.nombre_categoria AS categoria, 
                           p.id_modelo, m.modelo, p.id_talla, t.talla, p.id_tela, te.tela, 
                           p.precio, p.stock, p.imagen 
                    FROM productos p
                    LEFT JOIN categorias c ON p.id_categoria = c.id_categoria
                    LEFT JOIN modelos m ON p.id_modelo = m.id_modelo
                    LEFT JOIN tallas t ON p.id_talla = t.id_talla
                    LEFT JOIN telas te ON p.id_tela = te.id_tela";

        $result = $conn->query( $sql );
        $productos = [];

        while ( $row = $result->fetch_assoc() ) {
            $row[ 'imagen_base64' ] = $row[ 'imagen' ] !== null ? base64_encode( $row[ 'imagen' ] ) : null;
            unset( $row[ 'imagen' ] );
            // Eliminar campo binario original
            $productos[] = $row;
        }

        echo json_encode( $productos );
        break;

        case 'editar':
        $id          = validarParametro( 'id_producto' );
        $codigo      = validarParametro( 'codigo' );
        $nombre      = validarParametro( 'nombre' );
        $id_categoria = validarParametro( 'id_categoria' );
        $id_modelo   = validarParametro( 'id_modelo' );
        $id_talla    = validarParametro( 'id_talla' );
        $id_tela     = validarParametro( 'id_tela' );
        $precio      = validarParametro( 'precio' );
        $stock       = validarParametro( 'stock' );
        $imagenBinaria = obtenerImagenBinaria( 'imagen' );

        if ( $imagenBinaria !== null ) {
            $stmt = $conn->prepare(
                "UPDATE productos SET 
                        codigo=?, nombre=?, id_categoria=?, id_modelo=?, id_talla=?, id_tela=?, 
                        precio=?, stock=?, imagen=?
                     WHERE id_producto=?"
            );
            $null = null;
            $stmt->bind_param( 'ssiiiidsbi', $codigo, $nombre, $id_categoria, $id_modelo, $id_talla, $id_tela, $precio, $stock, $null, $id );
            $stmt->send_long_data( 8, $imagenBinaria );
        } else {
            $stmt = $conn->prepare(
                "UPDATE productos SET 
                        codigo=?, nombre=?, id_categoria=?, id_modelo=?, id_talla=?, id_tela=?, 
                        precio=?, stock=? 
                     WHERE id_producto=?"
            );
            $stmt->bind_param( 'ssiiiidsi', $codigo, $nombre, $id_categoria, $id_modelo, $id_talla, $id_tela, $precio, $stock, $id );
        }

        $resultado = $stmt->execute();

        echo json_encode( [
            'estado' => $resultado ? 'ok' : 'error',
            'mensaje' => $resultado ? 'Producto actualizado.' : 'Error: ' . $stmt->error
        ] );
        break;

        case 'eliminar':
        $id = validarParametro( 'id_producto' );

        $stmt = $conn->prepare( 'DELETE FROM productos WHERE id_producto=?' );
        $stmt->bind_param( 'i', $id );
        $resultado = $stmt->execute();

        echo json_encode( [
            'estado' => $resultado ? 'ok' : 'error',
            'mensaje' => $resultado ? 'Producto eliminado.' : 'Error al eliminar: ' . $stmt->error
        ] );
        break;

        default:
        echo json_encode( [
            'estado' => 'error',
            'mensaje' => 'Acción no válida.'
        ] );
    }
} catch ( Exception $e ) {
    echo json_encode( [
        'estado' => 'error',
        'mensaje' => 'Error del servidor: ' . $e->getMessage()
    ] );
}
