<?php
header( 'Content-Type: application/json' );
require_once '../CBDDCM/conexion.php';

$accion = $_GET[ 'accion' ] ?? '';
$conexion = Conexion::obtenerConexion();

function guardarLog( $accion, $datos ) {
    $log = '[' . date( 'Y-m-d H:i:s' ) . "] Acción: $accion\n";
    $log .= 'Datos: ' . print_r( $datos, true ) . '\n';
    $log .= '----------------------\n';
    file_put_contents( 'log.txt', $log, FILE_APPEND );
}

switch ( $accion ) {

    case 'listar_modelos':
    $sql = 'SELECT id_modelo, modelo FROM modelos ORDER BY id_modelo DESC';
    $result = $conexion->query( $sql );
    $modelos = [];
    while ( $row = $result->fetch_assoc() ) {
        $modelos[] = $row;
    }
    echo json_encode( $modelos );
    guardarLog( 'listar_modelos', [] );
    break;

    case 'registrar_modelo':
    $datos = json_decode( file_get_contents( 'php://input' ), true );
    $modelo = $conexion->real_escape_string( $datos[ 'modelo' ] ?? '' );

    if ( !$modelo ) {
        echo json_encode( [ 'error' => 'Modelo no válido' ] );
        exit;
    }

    $conexion->query( "INSERT INTO modelos (modelo) VALUES ('$modelo')" );
    echo json_encode( [ 'mensaje' => 'Modelo registrado correctamente' ] );
    guardarLog( 'registrar_modelo', $datos );
    break;

    case 'editar_modelo':
    $datos = json_decode( file_get_contents( 'php://input' ), true );
    $id_modelo = intval( $datos[ 'id_modelo' ] ?? 0 );
    $modelo = $conexion->real_escape_string( $datos[ 'modelo' ] ?? '' );

    if ( !$id_modelo || !$modelo ) {
        echo json_encode( [ 'error' => 'Datos inválidos' ] );
        exit;
    }

    $conexion->query( "UPDATE modelos SET modelo = '$modelo' WHERE id_modelo = $id_modelo" );
    echo json_encode( [ 'mensaje' => 'Modelo actualizado correctamente' ] );
    guardarLog( 'editar_modelo', $datos );
    break;

    case 'eliminar_modelo':
    $id = intval( $_GET[ 'id' ] ?? 0 );
    if ( !$id ) {
        echo json_encode( [ 'error' => 'ID inválido' ] );
        exit;
    }

    $conexion->query( "DELETE FROM modelos WHERE id_modelo = $id" );
    echo json_encode( [ 'mensaje' => 'Modelo eliminado correctamente' ] );
    guardarLog( 'eliminar_modelo', [ 'id' => $id ] );
    break;

    default:
    echo json_encode( [ 'error' => 'Acción no válida' ] );
    guardarLog( 'acción_no_válida', [ 'accion' => $accion ] );
    break;
}
