<?php
error_reporting( E_ALL );
ini_set( 'display_errors', 1 );

include '../CBDDCM/conexion.php';

// Configurar respuesta JSON
header( 'Content-Type: application/json' );
header( 'Cache-Control: no-cache, no-store, must-revalidate' );
header( 'Pragma: no-cache' );
header( 'Expires: 0' );

function enviarError( $mensaje ) {
    echo json_encode( [
        'estado' => 'error',
        'mensaje' => $mensaje
    ] );
    exit;
}

// Validar entrada de datos
$dni = filter_input( INPUT_POST, 'dni', FILTER_SANITIZE_STRING );
$contrasena = $_POST[ 'contrasena' ] ?? '';

if ( empty( $dni ) || strlen( $dni ) < 6 ) {
    enviarError( 'DNI inválido' );
}

if ( empty( $contrasena ) || strlen( $contrasena ) < 4 ) {
    enviarError( 'Contraseña inválida' );
}

try {
    mysqli_report( MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT );
    $conn = Conexion::obtenerConexion();

    $stmt = $conn->prepare( 'SELECT id_usuario, dni, correo, activo, contraseña FROM usuarios WHERE dni = ?' );
    $stmt->bind_param( 's', $dni );
    $stmt->execute();
    $resultado = $stmt->get_result();

    if ( $resultado->num_rows === 0 ) {
        enviarError( 'Usuario no encontrado' );
    }

    $usuario = $resultado->fetch_assoc();

    if ( ( int )$usuario[ 'activo' ] === 0 ) {
        enviarError( 'Usuario inactivo' );
    }

    if ( !password_verify( $contrasena, $usuario[ 'contraseña' ] ) ) {
        enviarError( 'Contraseña incorrecta' );
    }

    // Iniciar sesión segura
    session_start();
    session_regenerate_id( true );
    $_SESSION[ 'usuario_id' ] = $usuario[ 'id_usuario' ];
    $_SESSION[ 'usuario_dni' ] = $usuario[ 'dni' ];
    $_SESSION[ 'usuario_nombre' ] = $usuario[ 'nombre' ] ?? '';
    // Verifica que 'nombre' exista

    echo json_encode( [
        'estado' => 'ok',
        'mensaje' => 'Inicio de sesión exitoso'
    ] );

} catch ( Exception $e ) {
    error_log( 'Error de inicio de sesión: ' . $e->getMessage() );
    enviarError( 'Ocurrió un error en el servidor' );
}
finally {
    if ( isset( $stmt ) ) $stmt->close();
    if ( isset( $conn ) ) $conn->close();
}
