<?php
require_once '../CBDDCM/conexion.php';
header( 'Content-Type: application/json' );

$conn = Conexion::obtenerConexion();
$id_talla = $_POST[ 'id_talla' ] ?? null;

$sql = "SELECT p.nombre, m.modelo, t.talla, c.nombre_categoria AS categoria, p.imagen
        FROM productos p
        LEFT JOIN modelos m ON p.id_modelo = m.id_modelo
        LEFT JOIN tallas t ON p.id_talla = t.id_talla
        LEFT JOIN categorias c ON p.id_categoria = c.id_categoria";

$params = [];
$types = '';

if ( !empty( $id_talla ) ) {
    $sql .= ' WHERE p.id_talla = ?';
    $params[] = $id_talla;
    $types .= 'i';
}

$stmt = $conn->prepare( $sql );

// Si hay parámetros, los pasamos
if ( !empty( $params ) ) {
    $stmt->bind_param( $types, ...$params );
}

$stmt->execute();
$result = $stmt->get_result();

$productos = [];

while ( $row = $result->fetch_assoc() ) {
    $row[ 'imagen_base64' ] = $row[ 'imagen' ] ? base64_encode( $row[ 'imagen' ] ) : null;
    unset( $row[ 'imagen' ] );
    $productos[] = $row;
}

echo json_encode( $productos );
$conn->close();
