<?php
require_once '../CBDDCM/conexion.php';
header( 'Content-Type: application/json' );

$conn = Conexion::obtenerConexion();
$nombre = $_POST[ 'nombre' ] ?? '';

$sql = "SELECT p.nombre, m.modelo, t.talla, c.nombre_categoria AS categoria, p.imagen
        FROM productos p
        LEFT JOIN modelos m ON p.id_modelo = m.id_modelo
        LEFT JOIN tallas t ON p.id_talla = t.id_talla
        LEFT JOIN categorias c ON p.id_categoria = c.id_categoria
        WHERE p.nombre LIKE ?";
$nombreBusqueda = '%' . $nombre . '%';

$stmt = $conn->prepare( $sql );
$stmt->bind_param( 's', $nombreBusqueda );
$stmt->execute();
$result = $stmt->get_result();

$productos = [];
while ( $row = $result->fetch_assoc() ) {
    $row[ 'imagen_base64' ] = $row[ 'imagen' ] ? base64_encode( $row[ 'imagen' ] ) : null;
    unset( $row[ 'imagen' ] );
    $productos[] = $row;
}

echo json_encode( $productos );
