<?php
require_once '../CBDDCM/conexion.php';
header( 'Content-Type: application/json' );

$conn = Conexion::obtenerConexion();
$id_modelo = $_POST[ 'id_modelo' ] ?? null;

if ( $id_modelo === null ) {
    echo json_encode( [ 'estado' => 'error', 'mensaje' => 'ID de modelo no proporcionado.' ] );
    exit;
}

$sql = "SELECT p.nombre, m.modelo, t.talla, c.nombre_categoria AS categoria, p.imagen
        FROM productos p
        LEFT JOIN modelos m ON p.id_modelo = m.id_modelo
        LEFT JOIN tallas t ON p.id_talla = t.id_talla
        LEFT JOIN categorias c ON p.id_categoria = c.id_categoria
        WHERE p.id_modelo = ?";
$stmt = $conn->prepare( $sql );
$stmt->bind_param( 'i', $id_modelo );
$stmt->execute();
$result = $stmt->get_result();

$productos = [];
while ( $row = $result->fetch_assoc() ) {
    $row[ 'imagen_base64' ] = $row[ 'imagen' ] ? base64_encode( $row[ 'imagen' ] ) : null;
    unset( $row[ 'imagen' ] );
    $productos[] = $row;
}

echo json_encode( $productos );
