<?php
require_once '../CBDDCM/conexion.php';
header( 'Content-Type: application/json' );

$conn = Conexion::obtenerConexion();
$id_categoria = isset( $_POST[ 'id_categoria' ] ) && $_POST[ 'id_categoria' ] !== '' ? $_POST[ 'id_categoria' ] : null;

// Si viene un valor pero no es numérico, es error
if ( $id_categoria !== null && $id_categoria !== '' && !is_numeric( $id_categoria ) ) {
    echo json_encode( [ 'estado' => 'error', 'mensaje' => 'ID de categoría no válido.' ] );
    exit;
}

$sql = "SELECT p.nombre, m.modelo, t.talla, c.nombre_categoria AS categoria, p.imagen
        FROM productos p
        LEFT JOIN modelos m ON p.id_modelo = m.id_modelo
        LEFT JOIN tallas t ON p.id_talla = t.id_talla
        LEFT JOIN categorias c ON p.id_categoria = c.id_categoria";

if ( $id_categoria !== null ) {
    $sql .= ' WHERE p.id_categoria = ?';
    $stmt = $conn->prepare( $sql );
    $stmt->bind_param( 'i', $id_categoria );
} else {
    // Sin filtro, traer todos los productos
    $stmt = $conn->prepare( $sql );
}

$stmt->execute();
$result = $stmt->get_result();

$productos = [];
while ( $row = $result->fetch_assoc() ) {
    $row[ 'imagen_base64' ] = $row[ 'imagen' ] ? base64_encode( $row[ 'imagen' ] ) : null;
    unset( $row[ 'imagen' ] );
    $productos[] = $row;
}

echo json_encode( $productos );
