<?php
require_once '../CBDDCM/conexion.php';
// Asegúrate de tener tu clase Conexion lista

$conexion = Conexion::obtenerConexion();
$accion = $_GET[ 'accion' ] ?? '';

switch ( $accion ) {
    case 'listar':
    listar( $conexion );
    break;
    case 'registrar':
    registrar( $conexion );
    break;
    case 'editar':
    editar( $conexion );
    break;
    case 'eliminar':
    eliminar( $conexion );
    break;
    default:
    echo json_encode( [ 'error' => 'Acción no válida' ] );
}

function listar( $conexion ) {
    $sql = 'SELECT * FROM composiciones';
    $res = $conexion->query( $sql );
    $datos = [];

    while ( $fila = $res->fetch_assoc() ) {
        $datos[] = $fila;
    }

    echo json_encode( $datos );
}

function registrar( $conexion ) {
    $data = json_decode( file_get_contents( 'php://input' ), true );
    $composicion = $conexion->real_escape_string( $data[ 'composicion' ] );

    $sql = "INSERT INTO composiciones (composicion) VALUES ('$composicion')";
    if ( $conexion->query( $sql ) ) {
        echo json_encode( [ 'mensaje' => 'Composición registrada correctamente' ] );
    } else {
        echo json_encode( [ 'error' => 'Error al registrar' ] );
    }
}

function editar( $conexion ) {
    $data = json_decode( file_get_contents( 'php://input' ), true );
    $id = intval( $data[ 'id_composicion' ] );
    $composicion = $conexion->real_escape_string( $data[ 'composicion' ] );

    $sql = "UPDATE composiciones SET composicion = '$composicion' WHERE id_composicion = $id";
    if ( $conexion->query( $sql ) ) {
        echo json_encode( [ 'mensaje' => 'Composición actualizada correctamente' ] );
    } else {
        echo json_encode( [ 'error' => 'Error al actualizar' ] );
    }
}

function eliminar( $conexion ) {
    $id = intval( $_GET[ 'id' ] ?? 0 );
    $sql = "DELETE FROM composiciones WHERE id_composicion = $id";

    if ( $conexion->query( $sql ) ) {
        echo json_encode( [ 'mensaje' => 'Composición eliminada correctamente' ] );
    } else {
        echo json_encode( [ 'error' => 'Error al eliminar' ] );
    }
}
?>
