<?php
require_once '../CBDDCM/conexion.php';
// Asegúrate que tienes esta clase con obtenerConexion()

$conexion = Conexion::obtenerConexion();
$accion = $_GET[ 'accion' ] ?? '';

switch ( $accion ) {
    case 'listar':
    listarCategorias( $conexion );
    break;
    case 'registrar':
    registrarCategoria( $conexion );
    break;
    case 'eliminar':
    eliminarCategoria( $conexion );
    break;
    case 'editar':
    editarCategoria( $conexion );
    break;
    default:
    echo json_encode( [ 'error' => 'Acción no válida' ] );
}

function listarCategorias( $conexion ) {
    $sql = 'SELECT * FROM categorias';
    $resultado = $conexion->query( $sql );
    $categorias = [];

    while ( $fila = $resultado->fetch_assoc() ) {
        $categorias[] = $fila;
    }

    echo json_encode( $categorias );
}

function registrarCategoria( $conexion ) {
    $data = json_decode( file_get_contents( 'php://input' ), true );
    $nombre = $conexion->real_escape_string( $data[ 'nombre_categoria' ] );

    $sql = "INSERT INTO categorias (nombre_categoria) VALUES ('$nombre')";

    if ( $conexion->query( $sql ) ) {
        echo json_encode( [ 'mensaje' => 'Categoría registrada correctamente' ] );
    } else {
        echo json_encode( [ 'error' => 'Error al registrar la categoría' ] );
    }
}

function eliminarCategoria( $conexion ) {
    $id = intval( $_GET[ 'id' ] ?? 0 );
    $sql = "DELETE FROM categorias WHERE id_categoria = $id";

    if ( $conexion->query( $sql ) ) {
        echo json_encode( [ 'mensaje' => 'Categoría eliminada' ] );
    } else {
        echo json_encode( [ 'error' => 'Error al eliminar' ] );
    }
}

function editarCategoria( $conexion ) {
    $data = json_decode( file_get_contents( 'php://input' ), true );
    $id = intval( $data[ 'id_categoria' ] );
    $nombre = $conexion->real_escape_string( $data[ 'nombre_categoria' ] );

    $sql = "UPDATE categorias SET nombre_categoria = '$nombre' WHERE id_categoria = $id";

    if ( $conexion->query( $sql ) ) {
        echo json_encode( [ 'mensaje' => 'Categoría actualizada' ] );
    } else {
        echo json_encode( [ 'error' => 'Error al actualizar' ] );
    }
}
?>
