<?php
require_once 'CBDD/config.php';

$mensaje = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    
    if (empty($email) || empty($password)) {
        $mensaje = 'Por favor completa todos los campos';
    } else {
        try {
            $conn = getConnection();
            $stmt = $conn->prepare("SELECT id, nombre, email, password, tipo_plan, foto_perfil FROM usuarios WHERE email = ? AND estado = 'activo'");
            $stmt->execute([$email]);
            
            if ($stmt->rowCount() > 0) {
                $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
                
                if (password_verify($password, $usuario['password'])) {
                    $_SESSION['usuario_id'] = $usuario['id'];
                    $_SESSION['usuario_nombre'] = $usuario['nombre'];
                    $_SESSION['usuario_email'] = $usuario['email'];
                    $_SESSION['usuario_plan'] = $usuario['tipo_plan'];
                    $_SESSION['usuario_foto'] = $usuario['foto_perfil'];
                    
                    header('Location: FRONT/dashboard.php');
                    exit;
                } else {
                    $mensaje = 'Contraseña incorrecta';
                }
            } else {
                $mensaje = 'Usuario no encontrado';
            }
        } catch(PDOException $e) {
            $mensaje = 'Error: ' . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar Sesión - Aurora | Apoyo Emocional para Adolescentes</title>
    <link rel="stylesheet" href="CSS/index.css">
</head>
<body>
    <div class="main-container">
        <!-- Sección Izquierda -->
        <div class="image-section">
            <div class="image-content">
                <div class="logo-container">
                    <img id="logo_empresa"
                         src="IMG/1.png"
                         alt="Logo de Aurora"
                         onerror="this.src='data:image/svg+xml,%3Csvg xmlns=%22http://www.w3.org/2000/svg%22 width=%22120%22 height=%22120%22%3E%3Crect width=%22120%22 height=%22120%22 fill=%22%23667eea%22 rx=%2220%22/%3E%3Ctext x=%2250%25%22 y=%2250%25%22 font-size=%2248%22 fill=%22white%22 text-anchor=%22middle%22 dy=%22.3em%22%3E✨%3C/text%3E%3C/svg%3E'">
                    <div class="company-name">AURORA</div>
                    <div class="system-title">Tu Asistente Virtual de Apoyo Emocional</div>
                </div>

                <div class="features">
                    <div class="feature-item">
                        <div class="feature-icon">💬</div>
                        <div class="feature-text">
                            <div class="feature-title">Conversaciones Seguras</div>
                            <div class="feature-desc">Espacio confidencial para expresarte libremente</div>
                        </div>
                    </div>

                    <div class="feature-item">
                        <div class="feature-icon">🧠</div>
                        <div class="feature-text">
                            <div class="feature-title">Inteligencia Artificial</div>
                            <div class="feature-desc">Respuestas empáticas y personalizadas para ti</div>
                        </div>
                    </div>

                    <div class="feature-item">
                        <div class="feature-icon">📊</div>
                        <div class="feature-text">
                            <div class="feature-title">Seguimiento Emocional</div>
                            <div class="feature-desc">Registra tu progreso y bienestar diario</div>
                        </div>
                    </div>

                    <div class="feature-item">
                        <div class="feature-icon">🌟</div>
                        <div class="feature-text">
                            <div class="feature-title">Disponible 24/7</div>
                            <div class="feature-desc">Siempre aquí cuando nos necesites</div>
                        </div>
                    </div>
                </div>

                <div class="integrations">
                    <h4>Servicios Conectados:</h4>
                    <div class="integration-icons">
                        <span class="badge" title="Inteligencia Artificial">🤖 IA Avanzada</span>
                        <span class="badge" title="Análisis Emocional">💭 Análisis</span>
                        <span class="badge" title="Seguridad">🔒 Seguro</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sección Derecha - Login -->
        <div class="login-section">
            <div class="login-header">
                <h1 class="login-title">Bienvenido de vuelta</h1>
                <p class="login-subtitle">Ingresa tus credenciales para acceder a tu cuenta</p>
            </div>

            <!-- Mensaje de demostración -->
            <div class="mensaje info">
                <span>ℹ️</span>
                <span>por fabor no comparta sus credenciales</span>
            </div>

            <form method="POST" action="">
                <div class="form-group">
                    <label for="email">Correo Electrónico</label>
                    <div class="input-wrapper">
                        <input 
                            type="email" 
                            id="email"
                            name="email" 
                            placeholder="tu@email.com"
                            required
                            autocomplete="email">
                    </div>
                </div>

                <div class="form-group">
                    <label for="password">Contraseña</label>
                    <div class="input-wrapper">
                        <input 
                            type="password" 
                            id="password"
                            name="password" 
                            placeholder="••••••••"
                            required
                            autocomplete="current-password">
                    </div>
                </div>

                <button type="submit">Iniciar Sesión</button>
            </form>

            <div class="footer-links">
                <a href="FRONT/cambiar_password.php">¿Olvidaste tu contraseña?</a>
                <a href="FRONT/registro.php">¿No tienes cuenta? Regístrate aquí</a>
            </div>
        </div>
    </div>
</body>
</html>i