<?php
require_once '../CBDD/config.php';

$mensaje = '';
$tipo_mensaje = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nombre = trim($_POST['nombre']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirmar_password = $_POST['confirmar_password'];
    $tipo_plan = $_POST['tipo_plan'];
    
    // Validaciones
    if (empty($nombre) || empty($email) || empty($password)) {
        $mensaje = 'Por favor completa todos los campos';
        $tipo_mensaje = 'error';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $mensaje = 'Email inválido';
        $tipo_mensaje = 'error';
    } elseif (strlen($password) < 6) {
        $mensaje = 'La contraseña debe tener al menos 6 caracteres';
        $tipo_mensaje = 'error';
    } elseif ($password !== $confirmar_password) {
        $mensaje = 'Las contraseñas no coinciden';
        $tipo_mensaje = 'error';
    } else {
        try {
            $conn = getConnection();
            
            // Verificar si el email ya existe
            $stmt = $conn->prepare("SELECT id FROM usuarios WHERE email = ?");
            $stmt->execute([$email]);
            
            if ($stmt->rowCount() > 0) {
                $mensaje = 'El email ya está registrado';
                $tipo_mensaje = 'error';
            } else {
                // Hash de la contraseña
                $password_hash = password_hash($password, PASSWORD_DEFAULT);
                
                // Insertar usuario
                $stmt = $conn->prepare("INSERT INTO usuarios (nombre, email, password, tipo_plan) VALUES (?, ?, ?, ?)");
                $stmt->execute([$nombre, $email, $password_hash, $tipo_plan]);
                
                $usuario_id = $conn->lastInsertId();
                
                // Si es plan premium, redirigir a pago
                if ($tipo_plan === 'premium') {
                    $_SESSION['usuario_id_pago'] = $usuario_id;
                    header('Location: pago.php');
                    exit;
                } else {
                    $mensaje = 'Registro exitoso. Puedes iniciar sesión';
                    $tipo_mensaje = 'exito';
                }
            }
        } catch(PDOException $e) {
            $mensaje = 'Error al registrar: ' . $e->getMessage();
            $tipo_mensaje = 'error';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Crear Cuenta - Aurora | Apoyo Emocional para Adolescentes</title>
    <link rel="stylesheet" href="../CSS/registro.css">
</head>
<body>

<div class="container-2col">
    <!-- Columna Izquierda -->
    <div class="col-left">
        <div class="left-content">
            <div class="logo-section">
                <span class="logo-icon">✨</span>
                <h1>AURORA</h1>
                <p>Tu espacio seguro de apoyo emocional</p>
            </div>

            <div class="benefits-list">
                <div class="benefit-item">
                    <div class="benefit-icon">🛡️</div>
                    <div class="benefit-text">
                        <h3>100% Confidencial</h3>
                        <p>Tus conversaciones son privadas y seguras</p>
                    </div>
                </div>

                <div class="benefit-item">
                    <div class="benefit-icon">💭</div>
                    <div class="benefit-text">
                        <h3>Apoyo 24/7</h3>
                        <p>Siempre disponible cuando lo necesites</p>
                    </div>
                </div>

                <div class="benefit-item">
                    <div class="benefit-icon">🎯</div>
                    <div class="benefit-text">
                        <h3>Personalizado</h3>
                        <p>Se adapta a tus necesidades emocionales</p>
                    </div>
                </div>

                <div class="benefit-item">
                    <div class="benefit-icon">📊</div>
                    <div class="benefit-text">
                        <h3>Seguimiento</h3>
                        <p>Registra tu progreso y bienestar</p>
                    </div>
                </div>
            </div>

            <div class="trust-indicators">
                <h4>Respaldado por:</h4>
                <div class="badges">
                    <span class="badge">🤖 IA Avanzada</span>
                    <span class="badge">🔒 Encriptado</span>
                    <span class="badge">✅ Certificado</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Columna Derecha - Formulario -->
    <div class="col-right">
        <div class="form-header">
            <h2>Crear tu cuenta</h2>
            <p>Únete a miles de adolescentes que ya confían en Aurora</p>
        </div>

        

        <form method="POST" action="" id="registroForm">
            <div class="form-group">
                <label for="nombre">
                    Nombre completo
                    <span class="required">*</span>
                </label>
                <input 
                    type="text" 
                    id="nombre"
                    name="nombre" 
                    placeholder="Ej: María González"
                    required
                    autocomplete="name">
            </div>

            <div class="form-group">
                <label for="email">
                    Correo electrónico
                    <span class="required">*</span>
                </label>
                <input 
                    type="email" 
                    id="email"
                    name="email" 
                    placeholder="tu@email.com"
                    required
                    autocomplete="email">
            </div>

            <div class="form-group">
                <label for="password">
                    Contraseña
                    <span class="required">*</span>
                </label>
                <input 
                    type="password" 
                    id="password"
                    name="password" 
                    placeholder="Mínimo 6 caracteres"
                    required
                    autocomplete="new-password">
                <div class="password-strength" id="passwordStrength">
                    <div class="password-strength-bar" id="passwordStrengthBar"></div>
                </div>
                <div class="password-hint">
                    Usa letras, números y símbolos para mayor seguridad
                </div>
            </div>

            <div class="form-group">
                <label for="confirmar_password">
                    Confirmar contraseña
                    <span class="required">*</span>
                </label>
                <input 
                    type="password" 
                    id="confirmar_password"
                    name="confirmar_password" 
                    placeholder="Repite tu contraseña"
                    required
                    autocomplete="new-password">
            </div>

            <div class="form-group">
                <label>
                    Selecciona tu plan
                    <span class="required">*</span>
                </label>

                <div class="plan-selector">
                    <div class="plan-option selected" onclick="selectPlan('gratuito')">
                        <input type="radio" name="tipo_plan" value="gratuito" id="plan-gratuito" checked hidden>
                        <div class="plan-name">Plan Gratuito</div>
                        <div class="plan-price">S/ 0</div>
                        <div class="plan-period">Por siempre</div>
                        <div class="plan-features">
                            <div class="plan-feature">✓ Chat básico</div>
                            <div class="plan-feature">✓ Seguimiento emocional</div>
                            <div class="plan-feature">✓ Recursos de apoyo</div>
                        </div>
                    </div>

                    <div class="plan-option" onclick="selectPlan('premium')">
                        <span class="plan-badge">Popular</span>
                        <input type="radio" name="tipo_plan" value="premium" id="plan-premium" hidden>
                        <div class="plan-name">Plan Premium</div>
                        <div class="plan-price">S/ 100</div>
                        <div class="plan-period">Por mes</div>
                        <div class="plan-features">
                            <div class="plan-feature">✓ Todo lo del gratuito</div>
                            <div class="plan-feature">✓ Chat ilimitado</div>
                            <div class="plan-feature">✓ Análisis avanzado</div>
                            <div class="plan-feature">✓ Prioridad en soporte</div>
                        </div>
                    </div>
                </div>
            </div>

            <button type="submit" id="submitBtn">
                Crear mi cuenta
            </button>

            <div class="terms">
                Al registrarte, aceptas nuestros 
                <a href="terminos.php">Términos de Servicio</a> y 
                <a href="privacidad.php">Política de Privacidad</a>
            </div>
        </form>

        <div class="footer-links">
            ¿Ya tienes cuenta? <a href="../index.php">Iniciar sesión</a>
        </div>
    </div>
</div>

<script>
    // Selector de planes
    function selectPlan(plan) {
        document.querySelectorAll('.plan-option').forEach(opt => {
            opt.classList.remove('selected');
        });
        
        event.currentTarget.classList.add('selected');
        document.getElementById('plan-' + plan).checked = true;
    }

    // Indicador de fortaleza de contraseña
    const passwordInput = document.getElementById('password');
    const strengthIndicator = document.getElementById('passwordStrength');
    const strengthBar = document.getElementById('passwordStrengthBar');

    passwordInput.addEventListener('input', function() {
        const password = this.value;
        
        if (password.length === 0) {
            strengthIndicator.classList.remove('active');
            return;
        }
        
        strengthIndicator.classList.add('active');
        
        let strength = 0;
        if (password.length >= 6) strength++;
        if (password.length >= 10) strength++;
        if (/[a-z]/.test(password) && /[A-Z]/.test(password)) strength++;
        if (/\d/.test(password)) strength++;
        if (/[^a-zA-Z0-9]/.test(password)) strength++;
        
        strengthBar.className = 'password-strength-bar';
        
        if (strength <= 2) {
            strengthBar.classList.add('weak');
        } else if (strength <= 4) {
            strengthBar.classList.add('medium');
        } else {
            strengthBar.classList.add('strong');
        }
    });

    // Validación de formulario
    const form = document.getElementById('registroForm');
    const submitBtn = document.getElementById('submitBtn');

    form.addEventListener('submit', function(e) {
        const password = document.getElementById('password').value;
        const confirmPassword = document.getElementById('confirmar_password').value;
        
        if (password !== confirmPassword) {
            e.preventDefault();
            alert('Las contraseñas no coinciden');
            return false;
        }
        
        if (password.length < 6) {
            e.preventDefault();
            alert('La contraseña debe tener al menos 6 caracteres');
            return false;
        }
        
        // Agregar estado de carga
        submitBtn.classList.add('loading');
        submitBtn.textContent = 'Creando cuenta...';
    });

    // Prevenir envío múltiple
    let formSubmitted = false;
    form.addEventListener('submit', function(e) {
        if (formSubmitted) {
            e.preventDefault();
            return false;
        }
        formSubmitted = true;
    });
</script>

</body>
</html>
i