<?php
require_once '../CBDD/config.php';

// Verificar que hay un usuario pendiente de pago
if (!isset($_SESSION['usuario_id_pago'])) {
   header('Location: registro.php');
    exit;
}

$mensaje = '';
$tipo_mensaje = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $numero_tarjeta = str_replace(' ', '', $_POST['numero_tarjeta']);
    $nombre_tarjeta = trim($_POST['nombre_tarjeta']);
    $fecha_expiracion = $_POST['fecha_expiracion'];
    $cvv = $_POST['cvv'];
    
    // Validaciones básicas
    if (strlen($numero_tarjeta) != 16 || !is_numeric($numero_tarjeta)) {
        $mensaje = 'Número de tarjeta inválido';
        $tipo_mensaje = 'error';
    } elseif (strlen($cvv) != 3 || !is_numeric($cvv)) {
        $mensaje = 'CVV inválido';
        $tipo_mensaje = 'error';
    } else {
        // Simular procesamiento de pago
        try {
            $conn = getConnection();
            $usuario_id = $_SESSION['usuario_id_pago'];
            
            // Determinar tipo de tarjeta
            $primer_digito = substr($numero_tarjeta, 0, 1);
            $tipo_tarjeta = match($primer_digito) {
                '4' => 'Visa',
                '5' => 'Mastercard',
                '3' => 'American Express',
                default => 'Desconocida'
            };
            
            $ultimos_digitos = substr($numero_tarjeta, -4);
            
            // Registrar pago
            $stmt = $conn->prepare("INSERT INTO pagos (usuario_id, monto, tipo_tarjeta, ultimos_digitos, estado_pago) VALUES (?, ?, ?, ?, ?)");
            $stmt->execute([$usuario_id, 100.00, $tipo_tarjeta, $ultimos_digitos, 'aprobado']);
            
            // Actualizar usuario a premium
            $stmt = $conn->prepare("UPDATE usuarios SET tipo_plan = 'premium' WHERE id = ?");
            $stmt->execute([$usuario_id]);
            
            unset($_SESSION['usuario_id_pago']);
            
            $mensaje = 'Pago procesado exitosamente. Tu cuenta Premium ha sido activada.';
            $tipo_mensaje = 'exito';
            
            // Redirigir después de 2 segundos
            header("refresh:2;url=index.php");
            
        } catch(PDOException $e) {
            $mensaje = 'Error al procesar el pago: ' . $e->getMessage();
            $tipo_mensaje = 'error';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pago Premium - Aurora | Suscripción Segura</title>
    <link rel="stylesheet" href="../CSS/pago.css">
</head>
<body>
    <div class="main-container">
        <!-- Columna Izquierda - Info del Plan -->
        <div class="col-left">
            <div class="left-content">
                <div class="logo-section">
                    <span class="logo-icon">✨</span>
                    <h1>AURORA</h1>
                    <p class="subtitle">Tu apoyo emocional premium</p>
                </div>

                <div class="plan-card">
                    <span class="plan-badge">⭐ Premium</span>
                    <div class="plan-name">Plan Premium</div>
                    <div class="precio">S/ 100</div>
                    <div class="precio-info">Por mes</div>
                </div>

                 <div class="tarjeta-preview">
                <div class="tarjeta-header">
                    <div class="tarjeta-chip">💳</div>
                    <div class="card-type">VISA</div>
                </div>
                
                <div class="tarjeta-numero" id="preview-numero">•••• •••• •••• ••••</div>
                
                <div class="tarjeta-info">
                    <div>
                        <div class="tarjeta-label">Titular</div>
                        <div class="tarjeta-value" id="preview-nombre">NOMBRE APELLIDO</div>
                    </div>
                    <div style="text-align: right;">
                        <div class="tarjeta-label">Vence</div>
                        <div class="tarjeta-value" id="preview-fecha">MM/AA</div>
                    </div>
                </div>
            </div>
                

                
            </div>
        </div>

        <!-- Columna Derecha - Formulario de Pago -->
        <div class="col-right">
            <div class="form-header">
                <h2>Información de pago</h2>
                <p>Completa los datos de tu tarjeta de forma segura</p>
            </div>

           

            <!-- Tarjeta Preview -->
           

            <!-- Formulario -->
            <form method="POST" action="" id="paymentForm">
                <div class="form-group">
                    <label for="numero_tarjeta">
                        Número de tarjeta
                        <span class="required">*</span>
                    </label>
                    <div class="input-icon">
                        <input 
                            type="text" 
                            name="numero_tarjeta" 
                            id="numero_tarjeta" 
                            maxlength="19" 
                            placeholder="1234 5678 9012 3456"
                            autocomplete="cc-number"
                            required>
                        <span class="icon-right">💳</span>
                    </div>
                </div>

                <div class="form-group">
                    <label for="nombre_tarjeta">
                        Nombre en la tarjeta
                        <span class="required">*</span>
                    </label>
                    <input 
                        type="text" 
                        name="nombre_tarjeta" 
                        id="nombre_tarjeta" 
                        placeholder="Tal como aparece en la tarjeta"
                        autocomplete="cc-name"
                        required>
                </div>

                <div class="row">
                    <div class="form-group">
                        <label for="fecha_expiracion">
                            Vencimiento
                            <span class="required">*</span>
                        </label>
                        <input 
                            type="text" 
                            name="fecha_expiracion" 
                            id="fecha_expiracion" 
                            maxlength="5" 
                            placeholder="MM/AA"
                            autocomplete="cc-exp"
                            required>
                    </div>
                    <div class="form-group">
                        <label for="cvv">
                            CVV
                            <span class="required">*</span>
                        </label>
                        <div class="input-icon">
                            <input 
                                type="text" 
                                name="cvv" 
                                id="cvv"
                                maxlength="4" 
                                placeholder="123"
                                autocomplete="cc-csc"
                                required>
                            <span class="icon-right">🔒</span>
                        </div>
                    </div>
                </div>

                <button type="submit" id="submitBtn">
                    Procesar Pago - S/ 100.00
                </button>
            </form>

            <!-- Seguridad -->
            <div class="seguridad">
                <div class="seguridad-items">
                    <div class="seguridad-item">
                        <span class="seguridad-icon">🔒</span>
                        <span>SSL</span>
                    </div>
                    <div class="seguridad-item">
                        <span class="seguridad-icon">🛡️</span>
                        <span>Encriptado</span>
                    </div>
                    <div class="seguridad-item">
                        <span class="seguridad-icon">✓</span>
                        <span>Verificado</span>
                    </div>
                </div>
                
                <div class="payment-logos">
                    <div class="payment-logo">VISA</div>
                    <div class="payment-logo">MASTERCARD</div>
                    <div class="payment-logo">AMEX</div>
                </div>
            </div>

            <div class="back-link">
                <a href="registro.php">← Volver al registro</a>
            </div>
        </div>
    </div>

    <script>
        // Formatear número de tarjeta
        const numeroInput = document.getElementById('numero_tarjeta');
        const previewNumero = document.getElementById('preview-numero');

        numeroInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            value = value.substring(0, 16);
            let formattedValue = value.match(/.{1,4}/g)?.join(' ') || value;
            e.target.value = formattedValue;
            
            if (value.length > 0) {
                let preview = value.padEnd(16, '•').match(/.{1,4}/g).join(' ');
                previewNumero.textContent = preview;
            } else {
                previewNumero.textContent = '•••• •••• •••• ••••';
            }

            const cardType = document.querySelector('.card-type');
            if (value.startsWith('4')) {
                cardType.textContent = 'VISA';
            } else if (value.startsWith('5')) {
                cardType.textContent = 'MASTERCARD';
            } else if (value.startsWith('3')) {
                cardType.textContent = 'AMEX';
            } else {
                cardType.textContent = 'CARD';
            }
        });

        // Formatear nombre
        const nombreInput = document.getElementById('nombre_tarjeta');
        const previewNombre = document.getElementById('preview-nombre');

        nombreInput.addEventListener('input', function(e) {
            e.target.value = e.target.value.toUpperCase();
            let nombre = e.target.value || 'NOMBRE APELLIDO';
            previewNombre.textContent = nombre;
        });

        // Formatear fecha
        const fechaInput = document.getElementById('fecha_expiracion');
        const previewFecha = document.getElementById('preview-fecha');

        fechaInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length >= 2) {
                value = value.slice(0, 2) + '/' + value.slice(2, 4);
            }
            e.target.value = value;
            previewFecha.textContent = value || 'MM/AA';
        });

        // Validar solo números en CVV
        const cvvInput = document.getElementById('cvv');
        cvvInput.addEventListener('input', function(e) {
            e.target.value = e.target.value.replace(/\D/g, '');
        });

        // Validación del formulario
        const form = document.getElementById('paymentForm');
        const submitBtn = document.getElementById('submitBtn');

        form.addEventListener('submit', function(e) {
            e.preventDefault();

            const numero = numeroInput.value.replace(/\s/g, '');
            if (numero.length < 13 || numero.length > 19) {
                alert('Número de tarjeta inválido');
                return false;
            }

            const fecha = fechaInput.value;
            if (!/^\d{2}\/\d{2}$/.test(fecha)) {
                alert('Fecha de expiración inválida. Use formato MM/AA');
                return false;
            }

            const [mes, ano] = fecha.split('/').map(Number);
            if (mes < 1 || mes > 12) {
                alert('Mes inválido');
                return false;
            }

            const ano