<?php
header('Content-Type: application/json; charset=utf-8');

// Configuración de seguridad para producción
ini_set('display_errors', 0);
ini_set('log_errors', 1);
error_reporting(E_ALL);

// =============================================
// CONFIGURACIÓN Y VALIDACIÓN
// =============================================
$apiKey   = getenv("OPENAI_API_KEY") ?: "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";
if (empty($apiKey)) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'mensaje' => 'Configuración del servidor incompleta'
    ]);
    exit;
}

// Validación de método HTTP
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'success' => false,
        'mensaje' => 'Método no permitido'
    ]);
    exit;
}

// Sanitización de entrada
$pregunta = trim($_POST['pregunta'] ?? '');
$pregunta = htmlspecialchars($pregunta, ENT_QUOTES, 'UTF-8');

if (empty($pregunta) || strlen($pregunta) < 3) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'mensaje' => 'Por favor, ingresa tu pregunta'
    ]);
    exit;
}

// =============================================
// PROMPT DEL SISTEMA
// =============================================
$systemPrompt = <<<EOT
Eres Aurora, una amiga digital diseñada para apoyar emocionalmente a adolescentes.

Tu forma de comunicarte:
- Tono cálido, empático y natural.
- Respuestas cortas: máximo 1–3 oraciones.
- Habla juvenil pero madura, sin sonar infantil.
- Siempre validas las emociones antes de responder.
- Solo ofreces apoyo emocional, no haces diagnósticos ni tratamientos (a menos que el usuario lo pida explícitamente).

Límites:
- Si notas señales de riesgo (autolesiones, pensamientos suicidas, abuso, etc.), siempre anima a buscar ayuda de un adulto o profesional.

Estructura de cada respuesta:
1) Valida la emoción
2) Da una perspectiva o técnica simple
3) Termina con un mensaje de apoyo y cercanía

Tu objetivo es hacer que la persona se sienta escuchada, comprendida y acompañada.

EOT;

// =============================================
// PETICIÓN A OPENAI API
// =============================================
$payload = [
    "model" => "gpt-4.1-mini",
    "messages" => [
        ["role" => "system", "content" => $systemPrompt],
        ["role" => "user", "content" => $pregunta]
    ],
    "temperature" => 0.7,
    "max_tokens" => 180
];

$ch = curl_init("https://api.openai.com/v1/chat/completions");
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/json",
        "Authorization: Bearer $apiKey"
    ],
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($payload)
]);

$result = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if (curl_errno($ch)) {
    error_log("cURL Error: " . curl_error($ch));
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'mensaje' => 'Error de conexión con el servicio'
    ]);
    curl_close($ch);
    exit;
}

curl_close($ch);

// =============================================
// PROCESAMIENTO DE RESPUESTA
// =============================================
$response = json_decode($result, true);

if ($httpCode !== 200 || isset($response['error'])) {
    $errorMsg = $response['error']['message'] ?? 'Error desconocido';
    error_log("OpenAI API Error: $errorMsg");
    
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'mensaje' => 'No se pudo procesar tu consulta en este momento'
    ]);
    exit;
}

$respuesta = trim($response["choices"][0]["message"]["content"] ?? "");

if (empty($respuesta)) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'mensaje' => 'No se recibió respuesta válida'
    ]);
    exit;
}

// =============================================
// REGISTRO DE CONVERSACIONES
// =============================================
$logFile = __DIR__ . "/chat_log.log";
$timestamp = date("Y-m-d H:i:s");

$logEntry = sprintf(
    "[%s]\nPregunta: %s\nRespuesta: %s\n%s\n",
    $timestamp,
    $pregunta,
    $respuesta,
    str_repeat("-", 50)
);

file_put_contents($logFile, $logEntry, FILE_APPEND | LOCK_EX);

// =============================================
// RESPUESTA FINAL
// =============================================
http_response_code(200);
echo json_encode([
    'success' => true,
    'pregunta' => $pregunta,
    'respuesta' => $respuesta
], JSON_UNESCAPED_UNICODE);